# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import release as release_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import internal as internal_cubes

import sandbox.projects.Afisha.rm as rm_conf
import sandbox.projects.release_machine.core.const as rm_const


class AfishaInfraApiCfg(cfg.ReferenceCIConfig):

    name = "afisha_infra_api"
    responsible = cfg.Responsible(abc=cfg.Abc(component_id=4216, schedule_slug="sre_common_primary"), login="aarseniev")
    component_group = rm_conf.COMPONENT_GROUP

    class CI(cfg.ReferenceCIConfig.CI):
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = rm_conf.TRUNK_TASK_OWNER
        a_yaml_dir = "afisha/infra/projects/infra_api"
        ya_make_abs_paths_glob = [
            "afisha/infra/projects/infra_api/**",
        ]
        grant_config_update_permissions_to_release_machine_robot = False

    class JG(basic_build_presets.SingleBuildGeneralJGCfg):

        @property
        def release_task(self):
            return rm_conf.TASK_CI_REG_LOCATIONS["release2"]

        @property
        def build_task(self):
            return rm_conf.TASK_CI_REG_LOCATIONS["build"]

        def _get_build_cube(self, graph):
            return build_cubes.AfishaBuildDocker(
                component_name=self.component_name,
                package_path=self.root_cfg.releases_cfg.releasable_items[0].build_data.target,
                needs=[graph.get("main_graph_entry"), graph.get(internal_cubes.CreateStartrekTicket.NAME)],
                input=jg_cube.CubeInput(
                    arc_svn_url="arcadia-arc:/#${tasks.new_tag.rm_events[2].new_tag_data.arcadia_path}",
                    checkout_arcadia_from_url="arcadia-arc:/#${tasks.new_tag.rm_events[2].new_tag_data.arcadia_path}",
                ),
            )

        def _get_release_cubes(self, graph, build):
            result = []

            for deploy_system, where, releasable_items in (
                self._iter_over_releasable_items_with_release_stages_and_deploy_systems(build)
            ):
                result.append(
                    release_cubes.AfishaRelease2(
                        name="release_{}_{}".format(where, deploy_system),
                        component_name=self.component_name,
                        where_to_release=where,
                        manual=False,
                    )
                )

            return result

    class Notify(cfg.ReferenceCIConfig.Notify):
        """ Notification settings """

        class Telegram(cfg.ReferenceCIConfig.Notify.Telegram):
            """ Telegram notifications """
            chats = ["afisha-releases"]
            invite_link = "https://t.me/joinchat/A7R2dxPqytp73kyN-tywBw"

        class Startrek(cfg.ReferenceCIConfig.Notify.Startrek):
            """
            Startrek notifications

            https://wiki.yandex-team.ru/releasemachine/startrekoptions/
            """
            assignee = "aarseniev"
            queue = rm_conf.STARTREK_QUEUE
            followers = ["aarseniev", "maximus"]
            summary_template = "Infra Api {}"
            add_commiters_as_followers = True
            ticket_type = u"Релиз"
            use_task_author_as_assignee = False
            hide_commits_under_cut = True
            nanny_reports = False
            deadline = 7
            important_changes_limit = rm_conf.IMPORTANT_CHANGES_LIMIT

            @property
            def tags(self):
                return ["rm_main_ticket", self.name, "component_name_{}".format(self.name)]

    class ChangelogCfg(cfg.ReferenceCIConfig.ChangelogCfg):
        """
        Changelog configuration

        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """
        dirs = [
            "arcadia/afisha/infra/projects/infra_api"
        ]
        wiki_page = ""

    class SvnCfg(cfg.ReferenceCIConfig.SvnCfg):
        branch_name = "afisha/infra/api"  # E.g.: releases/afisha/infra/api/stable-N
        tag_name = "afisha/infra/api"     # E.g.: tags/releases/afisha/infra/api/N.K
        tag_folder_template = "{branch_num}.{tag_num}"
        start_version = 46  # moved to The CI since 46th branch

    class Releases(cfg.ReferenceCIConfig.Releases):
        """Releases configuration"""
        allow_robots_to_release_stable = True
        deploy_system = rm_const.DeploySystem.sandbox
        main_release_flow_branch_auto_start = False

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=rm_conf.RELEASE_RESOURCE,
                    data=ri.SandboxResourceData(
                        rm_conf.RELEASE_RESOURCE,
                        build_ctx_key="arc_svn_url",
                        attributes={"component_name": self.name},
                    ),
                    build_data=ri.BuildData(
                        target="afisha/infra/projects/infra_api/package.json",
                    ),
                    deploy_infos=[
                        ri.SandboxInfo(stage=rm_const.ReleaseStatus.stable)
                    ]
                )
            ]
