# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
from sandbox.projects.release_machine.components.job_graph.presets import ci_presets


class AgencyRewardsCICfg(cfg.ReferenceCIConfig):
    name = "agency_rewards"
    display_name = "Agency Rewards"
    responsible = cfg.Responsible(
        abc=cfg.Abc(service_name="ybar"),
        login="shorrty",
    )

    class CI(cfg.ReferenceCIConfig.CI):
        a_yaml_dir = "billing/agency_rewards"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "YBAR"
        grant_config_update_permissions_to_release_machine_robot = False

        class JobGraph(cfg.ReferenceCIConfig.CI.JobGraph):

            _preset = ci_presets.SingleBuildPackageCiPreset(
                resource_names="agency_rewards_deb",
                build_task_name="YA_PACKAGE_2",
                package_names=(
                    "billing/agency_rewards/pkg.json;"
                    "billing/agency_rewards/pkg.lb.json"
                ),
                build_apiargs={
                    "kill_timeout": 10800,
                },
                build_ctx={
                    "use_aapi_fuse": True,
                    "aapi_fallback": True,
                    "package_type": "debian",
                    "packages": (
                        "billing/agency_rewards/pkg.json;"
                        "billing/agency_rewards/pkg.lb.json"
                    ),
                    "resource_type": (
                        "AGENCY_REWARDS_DEB;"
                        "AGENCY_REWARDS_LB_DEB"
                    ),
                    "publish_package": True,
                    "publish_to": "yandex-trusty",
                    "strip_binaries": True,
                    "checkout": False,
                    "ya_yt_store": False,
                    "ignore_recurses": False,
                    "build_system": "ya",
                    "build_type": "release",
                    "key_user": "robot-billing-ci",
                    "dupload_max_attempts": 1,
                    "debian_distribution": "testing",
                    "use_new_format": True,
                    "custom_version": "2.${context.version_info.major}.${not_null(context.version_info.minor, `0`)}",
                },
                deploy_system=rm_const.DeploySystem.sandbox.name,
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable, jg_utils.CheckEachCommit()),
                ]
            )

    class Notify(cfg.ReferenceCIConfig.Notify):
        class Mail(cfg.ReferenceCIConfig.Notify.Mail):
            # # A list of email addresses that should receive email notifications
            mailing_list = ["shorrty", "estarchak"]

        class Startrek(cfg.ReferenceCIConfig.Notify.Startrek):
            """
            Startrek notifications

            https://wiki.yandex-team.ru/releasemachine/startrekoptions/
            """
            assignee = "shorrty"
            queue = "BALANCE"
            ticket_type = "Release"
            summary_template = u"Премии агенств: релиз 2.{}"
            followers = ["shorrty", "estarchak"]
            use_task_author_as_assignee = True
            nanny_reports = False
            important_changes_limit = 1000
            commit_importance_threshold = 1

    class ChangelogCfg(cfg.ReferenceCIConfig.ChangelogCfg):
        """
        Changelog configuration

        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """

        dirs = ["arcadia/billing/agency_rewards"]

        wiki_page = ""

    class SvnCfg(cfg.ReferenceCIConfig.SvnCfg):
        start_version = 40
        tag_folder_template = "{branch_num}.{tag_num}"
        tag_folder_pattern = r"([0-9]+)\.([0-9]+)"

    class Releases(cfg.ReferenceCIConfig.Releases):
        allow_old_releases = True
        allow_robots_to_release_stable = True

        release_followers_permanent = ["shorrty", "estarchak"]

        wait_for_deploy_time_sec = 15 * 60  # 15 min

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="agency_rewards_deb",
                    data=ri.SandboxResourceData("AGENCY_REWARDS_DEB"),
                ),
            ]
