# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


BUILD_RESOURCES = {
    "HORIZON_AGENT_CONFIG_ALICE": 90,
    "APP_HOST_STABLE_BRANCH_ALICE": 90,
}


class AliceEvoJobTypes(object):
    ALICE_EVO_APP_HOST_CONTEXT = "ALICE_EVO_APP_HOST_CONTEXT"
    ALICE_EVO_DIFF_CONFIG = "ALICE_EVO_DIFF_CONFIG"
    ALICE_EVO_INTEGRATION_TESTS = "ALICE_EVO_INTEGRATION_TESTS_WRAPPER"
    ALICE_EVO_MARKER_TESTS = "ALICE_EVO_MRKER_TESTS_WRAPPER"
    ALICE_EVO_UE_2_E = "ALICE_EVO_UE_2_E"


class AliceGraphsCfg(configs.ReferenceBranchedConfig):
    name = "alice_graphs"

    responsible = "petrk"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "VINS"
        branch_task_owner = "BASS"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(
                        ctx={"use_previous_branch_as_baseline": True}
                    ),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementWiki(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrekWiki(
                        next_revision_custom_schedule=jg_utils.CustomSchedule(
                            time_interval_list=[(1, 1)],
                            weekday_list=[2, 5],
                            once_a_day=True
                        )
                    ),
                ]

            @property
            def _trunk_part(self):
                trunk_part = super(self.__class__, self)._trunk_part
                trunk_part.append(
                    jg_build.JobGraphElementBuildTrunk(
                        task_name="BUILD_HORIZON_AGENT_CONFIG",
                        build_item="TRUNK",
                        out=BUILD_RESOURCES,
                        ctx={
                            "vertical": "ALICE",
                        },
                        job_params={
                            "observed_paths": ["apphost/conf/verticals/ALICE", "apphost/conf/backends/ALICE"],
                            "should_add_to_db": jg_utils.should_add_to_db_trunk,
                        }
                    )
                )
                trunk_part.append(
                    jg_release.JobGraphElementReleaseBase(
                        task_name="RELEASE_RM_COMPONENT_2",
                        release_to=rm_const.ReleaseStatus.testing,
                        release_item="TRUNK",
                        job_params={
                            "should_add_to_db": jg_utils.should_add_to_db_trunk,
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            "observed_paths": ["apphost/conf/verticals/ALICE", "apphost/conf/backends/ALICE"],
                            "ctx": {
                                "deploy_system": rm_const.DeploySystem.nanny.name,
                            }
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=[
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "alice_graphs",
                                        "APP_HOST_STABLE_BRANCH_ALICE",
                                    ),
                                ],
                                job_name_parameter="TRUNK",
                            ),
                        ),
                    )
                )
                return trunk_part

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name="BUILD_HORIZON_AGENT_CONFIG",
                        build_item="RELEASE",
                        out=BUILD_RESOURCES,
                        ctx={
                            "vertical": "ALICE",
                        },
                    )
                )
                branch_part.append(jg_test.JobGraphElementYappyBetaGeneratorBranched(
                    beta_conf_type="beta",
                    job_params={
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="RELEASE",
                            parent_job_data=(
                                jg_job_data.ParentDataDict(
                                    "component_resources",
                                    "alice_graphs",
                                    "APP_HOST_STABLE_BRANCH_ALICE",
                                ),
                            )
                        )
                    )
                ))
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name=AliceEvoJobTypes.ALICE_EVO_APP_HOST_CONTEXT,
                    job_params={
                        "job_name_parameter": AliceEvoJobTypes.ALICE_EVO_APP_HOST_CONTEXT,
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerGenerateBeta(
                            job_name_parameter="beta"
                        ),
                        jg_job_triggers.JobTriggerNewTag(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="evo_in_tag_num",
                                    output_key="new_tag_number",
                                ),
                            )
                        ),
                        jg_arrows.ParamsData("evo_in_branch_num", jg_utils.get_major_release_number),
                    )
                ))
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name=AliceEvoJobTypes.ALICE_EVO_INTEGRATION_TESTS,
                    job_params={
                        "job_name_parameter": AliceEvoJobTypes.ALICE_EVO_INTEGRATION_TESTS,
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    ctx={
                        "repeat_failed_test": True,
                        "run_call_owner_subtask": True,
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            job_name_parameter=AliceEvoJobTypes.ALICE_EVO_APP_HOST_CONTEXT,
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="launch_type",
                                    output_key="evo_out_component_name",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="branch_number",
                                    output_key="evo_out_branch_num",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="tag_number",
                                    output_key="evo_out_tag_num",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="megamind_url",
                                    output_key="evo_out_http_adapter_url",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="release_ticket",
                                    output_key="evo_out_release_ticket",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="beta_name",
                                    output_key="evo_out_beta_name",
                                )
                            )
                        ),
                    )
                ))
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name=AliceEvoJobTypes.ALICE_EVO_INTEGRATION_TESTS,
                    job_params={
                        "job_name_parameter": AliceEvoJobTypes.ALICE_EVO_MARKER_TESTS,
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    ctx={
                        "run_call_owner_subtask": True,
                        "subtask_type": "ALICE_EVO_MARKER_TESTS",
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            job_name_parameter=AliceEvoJobTypes.ALICE_EVO_APP_HOST_CONTEXT,
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="launch_type",
                                    output_key="evo_out_component_name",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="branch_number",
                                    output_key="evo_out_branch_num",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="tag_number",
                                    output_key="evo_out_tag_num",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="megamind_url",
                                    output_key="evo_out_http_adapter_url",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="release_ticket",
                                    output_key="evo_out_release_ticket",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="beta_name",
                                    output_key="evo_out_beta_name",
                                )
                            )
                        ),
                    )
                ))
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name=AliceEvoJobTypes.ALICE_EVO_UE_2_E,
                    ctx={
                        "fast_run": True,
                    },
                    job_params={
                        "job_name_parameter": AliceEvoJobTypes.ALICE_EVO_UE_2_E,
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            job_name_parameter=AliceEvoJobTypes.ALICE_EVO_APP_HOST_CONTEXT,
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="branch_num",
                                    output_key="evo_out_branch_num",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="tag_num",
                                    output_key="evo_out_tag_num",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="release_ticket",
                                    output_key="evo_out_release_ticket",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="megamind_url",
                                    output_key="evo_out_http_adapter_url",
                                ),
                            )
                        )
                    )
                ))
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    ctx={
                        "component_name": "alice_graphs"
                    },
                    task_name=AliceEvoJobTypes.ALICE_EVO_DIFF_CONFIG,
                    job_params={
                        "job_name_parameter": AliceEvoJobTypes.ALICE_EVO_DIFF_CONFIG,
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            job_name_parameter=AliceEvoJobTypes.ALICE_EVO_APP_HOST_CONTEXT,
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="branch_num",
                                    output_key="evo_out_branch_num",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="tag_num",
                                    output_key="evo_out_tag_num",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="release_ticket",
                                    output_key="evo_out_release_ticket",
                                ),
                            )
                        )
                    )
                ))
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(jg_release.JobGraphElementReleaseBranched(
                    release_to=rm_const.ReleaseStatus.stable,
                    job_arrows=[
                        jg_job_triggers.JobTriggerBuild(
                            parent_job_data=[
                                jg_job_data.ParentDataDict(
                                    "component_resources",
                                    self.name,
                                    "APP_HOST_STABLE_BRANCH_ALICE"
                                ),
                            ],
                            job_name_parameter="RELEASE",
                        ),
                    ],
                ))
                release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                    release_to=rm_const.ReleaseStatus.stable,
                    job_params={
                        "frequency": (jg_utils.TestFrequency.LAZY, None),
                    }
                ))
                return release_part

    class ReleaseViewer(configs.ReferenceBranchedConfig.ReleaseViewer):

        RELEASE_SAW_GRAPH = (
            "https://solomon.yandex-team.ru/?"
            "project=release_machine&cluster=default&service=release_statistics&description=Release+Saw&"
            "l.sensor=release_saw*&"
            "l.component_name=alice_graphs&"
            "graph=auto&stack=false&"
            "min=0&b=180d&e=&aggr=max&downsampling=byInterval&grid=1d&downsamplingAggr=max&graphOnly=y"
        )

        statistics_page_charts = [
            RELEASE_SAW_GRAPH,
        ] + configs.ReferenceBranchedConfig.ReleaseViewer.statistics_page_charts

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=self.name,
                    data=ri.SandboxResourceData("APP_HOST_STABLE_BRANCH_ALICE"),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService("production_app_host_{}_alice".format(i), tags=[i, "prod"])
                                for i in rm_const.MAIN_LOCATIONS
                            ] + [
                                ri.DeployService("hamster_app_host_alice", tags=["hamster"]),
                                ri.DeployService("ci_app_host_alice", tags=["ci"]),
                            ]
                        ),
                    ],
                ),
            ]

        release_followers_permanent = [
            "akhruslan",
            "petrk"
        ]
        allow_robots_to_release_stable = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/alice"
        tag_name = "apphost/conf/alice"

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "petrk"
            queue = "ALICERELEASE"
            summary_template = u"Приемка графов ALICE {}"
            followers = [
                "petrk"
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7
            commit_importance_threshold = 5

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "alice/infra/apphost/graphs/releases"
        ya_make_targets = [
            "arcadia/apphost/conf/verticals/ALICE",
        ]
        dirs = [
            "arcadia/apphost/conf/verticals/ALICE",
        ]

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "beta": yappy_cfg.YappyTemplateCfg(
                template_name="app-host-alice",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="app-host-alice",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                param_name="alice_graphs",
                                local_path="stable_branch",
                            )
                        ],
                        parent_service="hamster_app_host_alice",
                        ignore_instance_spec=True,
                    ),
                ],
                working_betas_limit=3,
            )
        }
