# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri

import sandbox.projects.release_machine.components.config_core.jg.base as jg_base
import sandbox.projects.release_machine.components.config_core.jg.flow as jg_flow
import sandbox.projects.release_machine.components.config_core.jg.cube.base as jg_cube_base
import sandbox.projects.release_machine.components.config_core.jg.cube.lib.build as jg_cube_build
import sandbox.projects.release_machine.components.config_core.jg.cube.lib.dummy as jg_cube_dummy
import sandbox.projects.release_machine.components.config_core.jg.cube.lib.release as jg_cube_release

RELEASABLE_RESOURCES = (
    "ALISA_SKILLS_REC_BSTR",
    "ALISA_SKILLS_REC_CONFIGS",
    "ALISA_SKILLS_REC_BSTR_RESOURCE_LOADER",
    "ALISA_SKILLS_REC_RESOURSE_TAR_CALLBACK",
    "ALISA_SKILLS_REC_BIN",
)


class AlisaSkillsRecCfg(cfg.ReferenceCIConfig):
    """
    Alisa Skills Recommender is an Alice component
    """

    name = "alisa_skills_rec"
    display_name = "Alisa Skills Recommender"
    responsible = "lavv17"
    responsible = cfg.Responsible(
        abc=cfg.Abc(service_name="alisa_skill_recommendation"),
        login="lavv17",
    )

    class CI(cfg.ReferenceCIConfig.CI):
        a_yaml_dir = "dj/services/alisa_skills"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "ALICE_SKILL_RECOMMENDATIONS"
        grant_config_update_permissions_to_release_machine_robot = False

        ya_make_abs_paths_glob = [
            "dj/services/alisa_skills/**",
        ]

    class JG(jg_base.BaseReleaseMachineJobGraph):
        @jg_flow.release_flow()
        def release(self):
            graph = super(self.__class__, self).release(self)

            build_alisa_skills_rec_package = jg_cube_build.YaMakeTemplate(
                name="build_alisa_skills_rec_package",
                title="Build Alisa SkillsRec Package",
                task="projects/alisa_skills_rec/build_alisa_skills_rec_package",
                input=jg_cube_base.CubeInput(
                    build_system="ya",
                    build_type="release",
                    test=True,
                    kill_timeout=6 * 3600
                ),
                needs=[graph.get(jg_cube_dummy.RMMainGraphEntry.NAME)]
            )
            graph.add(build_alisa_skills_rec_package)

            component_resources = {
                res_type.lower() : build_alisa_skills_rec_package.output.resources[res_type].first().id
                for res_type in RELEASABLE_RESOURCES
            }
            release_alisa_skills_rec_to_testing = jg_cube_release.ReleaseRmComponent2(
                name="release_alisa_skills_rec_to_testing",
                title="Release Alisa SkillsRec To Testing",
                component_name=self.component_name,
                where_to_release=rm_const.ReleaseStatus.testing,
                manual=False,
                input=jg_cube_base.CubeInput(
                    deploy_system=rm_const.DeploySystem.nanny.name,
                    major_release_num=rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM,
                    minor_release_num=rm_const.CIJMESPathCommon.MINOR_RELEASE_NUM,
                    component_resources=component_resources,
                    wait_for_deploy=True,
                ),
                needs=[build_alisa_skills_rec_package]
            )
            graph.add(release_alisa_skills_rec_to_testing)

            create_startrek_ticket = graph.get('create_startrek_ticket')

            run_alice_evo_tests = jg_cube_base.Cube(
                name="run_alice_evo_tests",
                title="Run Alice Evo Integration Tests",
                task="projects/alice/alice_evo_integration_tests_wrapper",
                input=jg_cube_base.CubeInput(
                    test_filters="proactivity",
                    megamind_url="http://vins.hamster.alice.yandex.net/speechkit/app/pa/"
                                 "?srcrwr=SKILL_PROACTIVITY_HTTP:skills-rec-test.alice.yandex.net:80",
                    launch_type=AlisaSkillsRecCfg.name,
                    branch_number=rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM,
                    tag_number=rm_const.CIJMESPathCommon.MINOR_RELEASE_NUM,
                    release_ticket=create_startrek_ticket.output.st_ticket.key
                ),
                needs=[create_startrek_ticket, release_alisa_skills_rec_to_testing]
            )
            graph.add(run_alice_evo_tests)

            run_skill_rec_perf_test = jg_cube_base.Cube(
                name="run_skill_rec_perf_test",
                title="Run SkillRec Perf Test",
                task="projects/alisa_skills_rec/run_skill_rec_perf_test",
                input=jg_cube_base.CubeInput(
                    testing_target_dc="sas",
                    stable_release_tag="auto",
                    rps_min=50,
                    rps_max_old=300,
                    rps_max_new=300,
                    binary_executor_release_type="stable",
                    startrek_ticket_id=create_startrek_ticket.output.st_ticket.key,
                    test_release_tag="{}-{}".format(rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM, rm_const.CIJMESPathCommon.MINOR_RELEASE_NUM)
                ),
                needs=[create_startrek_ticket, run_alice_evo_tests]
            )
            graph.add(run_skill_rec_perf_test)

            release_alisa_skills_rec_to_stable = jg_cube_release.ReleaseRmComponent2(
                name="release_alisa_skills_rec_to_stable",
                title="Release Alisa SkillsRec To Stable",
                component_name=self.component_name,
                where_to_release=rm_const.ReleaseStatus.stable,
                manual=True,
                input=jg_cube_base.CubeInput(
                    deploy_system=rm_const.DeploySystem.nanny.name,
                    major_release_num=rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM,
                    minor_release_num=rm_const.CIJMESPathCommon.MINOR_RELEASE_NUM,
                    component_resources=component_resources,
                    wait_for_deploy=False,
                ),
                needs=[build_alisa_skills_rec_package, run_skill_rec_perf_test]
            )
            graph.add(release_alisa_skills_rec_to_stable)

            return graph

    class Notify(cfg.ReferenceCIConfig.Notify):

        class Telegram(cfg.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["bass_comp"]
            config = cfg.RmTelegramNotifyConfig(chats=chats)
            invite_link = "https://t.me/joinchat/AAAAAEmzjCB_Rzj8IOolew"

        class Startrek(cfg.ReferenceCIConfig.Notify.Startrek):
            """
            Startrek notifications

            https://wiki.yandex-team.ru/releasemachine/startrekoptions/
            """

            assignee = "lavv17"
            queue = "ALICERELEASE"
            dev_queue = "ALICE"
            summary_template = u"Релиз Alisa Skills Recommender {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                assignee,
                "karina-usm",
            ]
            add_commiters_as_followers = True
            hide_commits_under_cut = True

    class ChangelogCfg(cfg.ReferenceCIConfig.ChangelogCfg):
        """
        Changelog configuration

        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """

        dirs = [
            "arcadia/dj/services/alisa_skills"
        ]
        wiki_page = "alice/skillrec/changelogs/"
        review_groups = [
            "alice_skill_recommendations"
        ]

    class Releases(cfg.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=resource_type.lower(),
                    data=ri.SandboxResourceData(resource_type, ttl=7),
                    deploy_infos=[
                        ri.NannyDeployInfo([
                            ri.DeployService("alisa-skills-rec-production-yp-{}".format(i))
                            for i in rm_const.MAIN_LOCATIONS
                        ]),
                    ],
                ) for resource_type in RELEASABLE_RESOURCES
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 60 * 60
        main_release_flow_branch_auto_start = False

    class MetricsCfg(cfg.ReferenceCIConfig.MetricsCfg):
        """ Metrics configuration """
        limit_s = 14 * 60 * 60          # Limit for SERPs downloads (in seconds)
        default_launch_id = ""          # Default launch ID

    class Yappy(cfg.ReferenceCIConfig.Yappy):
        working_betas_limit = 3
        wait_for_deploy_time_sec = 4 * 60 * 60
        betas = {}

    class SvnCfg(cfg.ReferenceCIConfig.SvnCfg):
        use_arc = True
        start_version = 76  # moved to the CI since 75nd branch
