# -*- coding: utf-8 -*-

from sandbox.projects.common import constants as sandbox_constants
from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri

import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class AntirobotCfg(cfg.ReferenceBranchedConfig):
    name = "antirobot"
    display_name = "Antirobot Daemon"
    responsible = "ashagarov"

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        new_task_owner = "ANTIROBOT"
        trunk_task_owner = "ANTIROBOT"

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrek(),
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name="YA_PACKAGE_2",
                        job_params={
                            "job_name_parameter": "RELEASE_ANTIROBOT_DAEMON_BUNDLE",
                        },
                        ctx={
                            sandbox_constants.CLEAR_BUILD_KEY: False,
                            sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.YMAKE_BUILD_SYSTEM,
                            sandbox_constants.ALLOW_AAPI_FALLBACK: True,
                            sandbox_constants.USE_AAPI_FUSE: True,
                            sandbox_constants.USE_ARC_INSTEAD_OF_AAPI: False,
                            sandbox_constants.YA_YT_TOKEN_YAV_SECRET: 'sec-01fbs6wgy49884z9c1wrvp3nd7#YT_TOKEN',
                            sandbox_constants.ARC_SECRET: 'sec-01fbs7g0ddp50brb28qcesch51#access_token',
                            "packages": "antirobot/build/antirobot-bundle/bundle.json",
                            "resource_type": "ANTIROBOT_BUNDLE",
                            "package_type": "tarball",
                            "publish_package": False,
                            "compress_package_archive": True,

                        },
                        out={
                            'ANTIROBOT_BUNDLE': 90,
                        },
                    ))

                arcadia_tests = [
                    (
                        [
                            "antirobot/lib/ut",
                            "antirobot/daemon_lib/ut",
                            "antirobot/daemon_lib/ut_medium",
                            "antirobot/daemon/arcadia_test",
                        ],
                        [
                            None,
                            'address',
                            'memory',
                            'undefined',
                        ]
                    ),
                ]
                for targets, sanitizers in arcadia_tests:
                    for sanitize in sanitizers:
                        if sanitize:
                            job_name_parameter = "ARCADIA_TESTS_SANITIZE_" + sanitize.upper()
                        else:
                            job_name_parameter = "ARCADIA_TESTS"

                        branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                            task_name="YA_MAKE_2",
                            job_params={
                                "job_name_parameter": job_name_parameter,
                                "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                                "apiargs": {
                                    "kill_timeout": 5 * 3600,
                                }
                            },
                            job_arrows=(
                                jg_arrows.ParamsData(
                                    input_key=sandbox_constants.ARCADIA_URL_KEY,
                                    transform=lambda x, params: "{}/arcadia@{}".format(x.svn_ssh_url, x.revision),
                                ),
                            ),
                            ctx={
                                "targets": ';'.join(targets),
                                "test": True,
                                "failed_tests_cause_error": False,  # manually check tests
                                "disable_test_timeout": True,
                                "sanitize": sanitize,
                                "tests_retries": 2,
                                "cache_test_results": False,
                                'report_tests_only': True,
                                sandbox_constants.CLEAR_BUILD_KEY: False,
                                sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.YMAKE_BUILD_SYSTEM,
                                sandbox_constants.ALLOW_AAPI_FALLBACK: True,
                                sandbox_constants.USE_AAPI_FUSE: True,
                                sandbox_constants.USE_ARC_INSTEAD_OF_AAPI: False,
                                sandbox_constants.YA_YT_TOKEN_YAV_SECRET: 'sec-01fbs6wgy49884z9c1wrvp3nd7#YT_TOKEN',
                                sandbox_constants.ARC_SECRET: 'sec-01fbs7g0ddp50brb28qcesch51#access_token',
                            },
                        ))
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_stages = [rm_const.ReleaseStatus.stable, rm_const.ReleaseStatus.prestable, rm_const.ReleaseStatus.testing]

                build_resources_info = (
                    jg_job_triggers.JobTriggerBuild(
                        parent_job_data=(
                            jg_job_data.ParentDataDict(
                                "component_resources",
                                'antirobot_bundle',
                                'ANTIROBOT_BUNDLE',
                            ),
                        ),
                        job_name_parameter="RELEASE_ANTIROBOT_DAEMON_BUNDLE",
                    ),
                    jg_job_triggers.JobTriggerNewTag([
                        jg_job_data.ParentDataCtx("major_release_num", "branch_number_for_tag"),
                        jg_job_data.ParentDataCtx("minor_release_num", "new_tag_number"),
                        jg_job_data.ParentDataCtx("release_number", "scope_number", override=True),
                    ]),
                )
                for release_stage in release_stages:
                    release_part.append(jg_release.JobGraphElementReleaseBranched(
                        release_to=release_stage,
                        job_arrows=build_resources_info,
                    ))
                    release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                        release_to=release_stage,
                    ))
                return release_part

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="antirobot_bundle",
                    data=ri.SandboxResourceData("ANTIROBOT_BUNDLE"),
                    deploy_infos=[ri.NannyDeployInfo([
                        ri.DeployService("prod_antirobot_yp_{}".format(loc)) for loc in rm_const.MAIN_LOCATIONS
                    ])]
                ),
            ]

        release_followers_permanent = [
            "ashagarov",
        ]
        wait_for_deploy_time_sec = 2 * 60 * 60
        allow_robots_to_release_stable = True

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = ""
        dirs = [
            "arcadia/antirobot",
        ]

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Mail(cfg.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = [
                "antirobots@yandex-team.ru",
            ]

        class Telegram(cfg.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["Антиробот"]
            config = cfg.RmTelegramNotifyConfig(chats=chats)
            invite_link = "https://t.me/joinchat/E7cVYFfmAGuk94neIRQ-ag"

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "ashagarov"
            queue = "CAPTCHAREL"
            dev_queue = "CAPTCHA"
            summary_template = "Приемка Антиробота {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "rzhikharevich",
                "tyamgin",
                "toshchakov",
            ]
            add_commiters_as_followers = True
            deadline = 7
            notify_on_deploy_to_feature_st_tickets = True

            def on_release_close_tickets_by_query(self, st_issue_key=None):
                if st_issue_key:
                    return '"Linked To": {} AND Status: Commited (Queue: "CAPTCHA")'.format(
                        st_issue_key
                    )

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        allow_autobranches = True
