from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base import SearchReleasesBuildTestCube
from sandbox.projects.release_machine.components.config_core.jg.cube.base import CubeInput


class CachedaemonTestsBundle():
    @staticmethod
    def get_bundle(sanitizers, entry_cube):
        """
        Returns list of apphost_cachedaemon component tests

        :type sanitizers: List[str]
        :param sanitizers:
            List of sanitizers for ya_make tests

        :type entry_cube: Cube
        :param entry_cube:
            The name of the build stage entry cube for ya_make tests dependencies
        """

        return [
            SearchReleasesBuildTestCube(
                name="ya_make_tests_sanitize_{}".format(sanitizer) if sanitizer else "ya_make_tests_sanitize",
                task="KOSHER_YA_MAKE",
                input=CubeInput(
                    targets="web/daemons/cached/tests",
                    test=True,
                    disable_test_timeout=True,
                    sanitize=sanitizer,
                ),
                needs=[entry_cube],
            ) for sanitizer in sanitizers
        ]
