# -*- coding: utf-8 -*-


from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core.jg.preset import apphost_vertical_presets
from sandbox.projects.release_machine.core import releasable_items as ri


RESOURCES = [
    "HORIZON_AGENT_CONFIG_EXAMPLE",
    "APP_HOST_STABLE_BRANCH_EXAMPLE",
]


class ExampleGraphsCfg(configs.ReferenceCIConfig):

    component_group = "apphost_verticals"
    name = "example_graphs_rmci"

    responsible = configs.Responsible(
        abc=configs.Abc(service_name="apphost"),
        login="gvdozd"
    )

    class JG(apphost_vertical_presets.ApphostVerticalJGCfg):
        build_task = "BUILD_HORIZON_AGENT_CONFIG"
        vertical_name = "example"

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "apphost/conf/verticals/EXAMPLE"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "HORIZON"

        ya_make_abs_paths_glob = [
            "apphost/conf/verticals/EXAMPLE/**",
        ]

    class Releases(configs.ReferenceCIConfig.Releases):

        @property
        def releasable_items(self):  # type: () -> List[ri.AbstractReleasableItem]
            return [
                ri.ReleasableItem(
                    name=resource.lower(),
                    data=ri.SandboxResourceData(resource, ttl=90),
                    deploy_infos=[
                        ri.NannyDeployInfo(ri.DeployService("production_app_host_sas_example"), dashboards=["apphost_example"]),
                    ]
                ) for resource in RESOURCES
            ]

        allow_robots_to_release_stable = True

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        branch_name = "apphost/conf/example"
        tag_name = "apphost/conf/example"
        start_version = 27

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "gvdozd"
            queue = "APPHOSTGRAPHS"
            summary_template = u"Приемка графов EXAMPLE {}"
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = ""
        observed_paths = [
            "arcadia/apphost/conf/verticals/EXAMPLE"
        ]
