# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


RESOURCES = [
    "HORIZON_AGENT_CONFIG_GOODS",
    "APP_HOST_STABLE_BRANCH_GOODS",
]


class GoodsGraphsCfg(configs.ReferenceBranchedConfig):
    component_group = "apphost_verticals"
    name = "goods_graphs"
    responsible = "yurikiselev"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = "GOODS-RUNTIME"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SingleBuildPreset(
                build_task_name="BUILD_HORIZON_AGENT_CONFIG",
                build_ctx={
                    "vertical": "GOODS",
                },
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="beta",
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "app_host_stable_branch",
                                        "APP_HOST_STABLE_BRANCH_GOODS",
                                    ),
                                )
                            )
                        )
                    )
                )
                return branch_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=resource.lower(),
                    data=ri.SandboxResourceData(resource, ttl=90),
                    deploy_infos=[
                        ri.NannyDeployInfo(ri.DeployService("production_app_host_man_goods"), dashboards=["apphost_goods"]),
                    ],
                ) for resource in RESOURCES
            ]

        allow_robots_to_release_stable = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/goods"
        tag_name = "apphost/conf/goods"

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "yurikiselev"
            queue = "GOODSAPPHOST"
            summary_template = u"Приемка графов GOODS {}"
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = ""
        observed_paths = [
            "arcadia/apphost/conf/verticals/GOODS"
        ]

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "beta": yappy_cfg.YappyTemplateCfg(
                template_name="goods-apphost-test",
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="goods-apphost",
                        resources=[
                            yappy_cfg.YappyParametrizedResource("app_host_stable_branch", "stable_branch"),
                        ],
                        parent_service="hamster_app_host_sas_goods"
                    ),
                ],
                new_yappy=True,
            ),
        }
