# -*- coding: utf-8 -*-


from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core.jg.preset import apphost_vertical_presets
from sandbox.projects.release_machine.core import releasable_items as ri


RESOURCES = [
    "HORIZON_AGENT_CONFIG_GOODS",
    "APP_HOST_STABLE_BRANCH_GOODS",
]


class GoodsGraphsCfg(configs.ReferenceCIConfig):

    component_group = "apphost_verticals"
    name = "goods_graphs_rmci"

    responsible = configs.Responsible(
        abc=configs.Abc(service_name="goods"),
        login="yurikiselev",
    )

    class JG(apphost_vertical_presets.ApphostVerticalJGCfg):
        build_task = "BUILD_HORIZON_AGENT_CONFIG"
        vertical_name = "goods"

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "apphost/conf/verticals/GOODS"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "GOODS-RUNTIME"

        ya_make_abs_paths_glob = [
            "apphost/conf/verticals/GOODS/**",
        ]

    class Releases(configs.ReferenceCIConfig.Releases):

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=resource.lower(),
                    data=ri.SandboxResourceData(resource, ttl=90),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            ri.DeployService("production_app_host_sas_goods"),
                            dashboards=["apphost_goods"],
                        ),
                    ],
                ) for resource in RESOURCES
            ]

        allow_robots_to_release_stable = True

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        branch_name = "apphost/conf/goods"
        tag_name = "apphost/conf/goods"
        start_version = 87

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "yurikiselev"
            queue = "GOODSAPPHOST"
            summary_template = u"Приемка графов GOODS {}"
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = ""
        observed_paths = [
            "arcadia/apphost/conf/verticals/GOODS",
        ]

    class Yappy(configs.yappy.YappyBaseCfg):
        betas = {
            "beta": configs.yappy.YappyTemplateCfg(
                template_name="goods-apphost-test",
                patches=[
                    configs.yappy.YappyTemplatePatch(
                        patch_dir="goods-apphost",
                        resources=[
                            configs.yappy.YappyParametrizedResource("app_host_stable_branch", "stable_branch"),
                        ],
                        parent_service="hamster_app_host_sas_goods",
                    ),
                ],
                new_yappy=True,
            ),
        }
