# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class HealthGraphsCfg(configs.ReferenceBranchedConfig):
    component_group = "apphost_verticals"
    name = "health_graphs"
    responsible = "alt-j"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = "YA_HEALTH"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementWiki(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrekWiki(
                        job_params={
                            "filter_targets": [
                                "apphost/conf/verticals/HEALTH",
                            ],
                        },
                        next_revision_custom_schedule=jg_utils.CustomSchedule(
                            last_run_finished=False,
                            seconds_from_last_run_commit=3600,
                            seconds_from_last_run_start_time=3600,
                            time_interval_list=[(12, 13), (17, 18)],
                            weekday_list=[0, 1, 2, 3, 4, 5],
                        ),
                    ),
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name="BUILD_HORIZON_AGENT_CONFIG",
                        build_item="HORIZON_AGENT_CONFIG",
                        out={
                            "HORIZON_AGENT_CONFIG_HEALTH": 90,
                            "APP_HOST_STABLE_BRANCH_HEALTH": 90,
                        },
                        ctx={
                            "vertical": "HEALTH",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="beta",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="HORIZON_AGENT_CONFIG",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="stable_branch_res_id",
                                        resource_name="APP_HOST_STABLE_BRANCH_HEALTH",
                                    ),
                                ),
                            )
                        )
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="YAMD_ACCEPTANCE_BEGEMOT_GRAPH_TASK",
                        job_params={
                            "job_name_parameter": "TEST_HEALTH_GRAPHS",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="beta_url",
                                        output_key="beta_name",
                                        transform=lambda x, params: "http://{}.hamster.yandex.ru/health/search".format(
                                            x),
                                    ),
                                ),
                            ),
                        ),
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="TEST_HEALTH_GRAPHS",
                            ),
                        ),
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(jg_release.JobGraphElementReleaseBranched(
                    release_to=rm_const.ReleaseStatus.stable,
                    job_arrows=[
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="HORIZON_AGENT_CONFIG",
                            parent_job_data=[
                                jg_job_data.ParentDataDict(
                                    "component_resources",
                                    "stable_branch_res_id",
                                    "APP_HOST_STABLE_BRANCH_HEALTH"
                                ),
                            ],
                        ),
                        jg_job_triggers.JobTriggerActionRunAcceptanceBranchedTest(
                            job_name_parameter="BY_MARKER",
                        ),
                    ],
                ))
                release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                    release_to=rm_const.ReleaseStatus.stable,
                    job_params={
                        "task_name": "DEPLOY_NANNY_DASHBOARD",
                        "ctx": {
                            'deployment_release_status': rm_const.ReleaseStatus.stable,
                            'deployment_nanny_dashboard_name': 'apphost_health',
                            'deployment_nanny_dashboard_recipe': 'health',
                            'vault_name': 'nanny_oauth_token',
                            'vault_owner': 'APP_HOST',
                            'deployment_nanny_bool_wait': True
                        },
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="HORIZON_AGENT_CONFIG",
                            parent_job_data=(
                                jg_job_data.ParentDataId(
                                    input_key="deployment_task_id",
                                ),
                            ),
                        ),
                    )
                ))
                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="graphs",
                resource_type="APP_HOST_STABLE_BRANCH_HEALTH",
                resource_name="stable_branch_res_id",
                deploy=[configs.DeployServicesInfo(services=["production_app_host_sas_health"], dashboards=["apphost_health"])],
            ),
        ]
        allow_robots_to_release_stable = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/health"
        tag_name = "apphost/conf/health"

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "ro-ivanov"
            queue = "HEALTHREL"
            summary_template = u"Приемка графов HEALTH {}"
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = ""
        dirs = [
            "arcadia/apphost/conf/verticals/HEALTH"
        ]

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "beta": yappy_cfg.YappyTemplateCfg(
                template_name="apphost-health",
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="apphost-health",
                        resources=[
                            yappy_cfg.YappyParametrizedResource("stable_branch_res_id", "stable_branch"),
                        ],
                        parent_service="hamster_app_host_man_health"
                    ),
                ],
                new_yappy=True,
            ),
        }
