# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


RESOURCES = [
    "HORIZON_AGENT_CONFIG_NEWS",
    "APP_HOST_STABLE_BRANCH_NEWS",
]


class NewsGraphsCfg(configs.ReferenceBranchedConfig):
    component_group = "apphost_verticals"
    name = "news_graphs"
    responsible = "volcolac"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "NEWS"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SingleBuildPreset(
                build_task_name="BUILD_HORIZON_AGENT_CONFIG",
                build_ctx={
                    "vertical": "NEWS",
                },
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable),
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.testing, jg_utils.CheckEachCommit()),
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.prestable, jg_utils.CheckEachCommit()),
                ],
            )

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=resource.lower(),
                    data=ri.SandboxResourceData(resource, ttl=90),
                    deploy_infos=[ri.single_nanny_service("production_news_app_host")],
                ) for resource in RESOURCES
            ]

        allow_robots_to_release_stable = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/news"
        tag_name = "apphost/conf/news"

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "volcolac"
            queue = "NEWREL"
            summary_template = u"Приемка графов NEWS {}"
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = ""
        dirs = [
            "arcadia/apphost/conf/verticals/NEWS"
        ]
