# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class ArchiveCfg(configs.ReferenceCIConfig):
    name = "archive"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="archive_search"),
        login="bvshuryg",
    )
    robot = "robot-archive"

    class JG(basic_build_presets.SingleBuildYaPackageJGCfg):
        def _get_build_cube(self, graph):
            build = super(self.__class__, self)._get_build_cube(graph)
            build.input.update(raw_package=True)  # do not tarball, so we don't have to unpack it in nanny
            return build

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "robot/archive"
        secret = "sec-01g3140kq2cta1v184wsd365tj"
        sb_owner_group = "ARCHIVE"

        ya_make_abs_paths_glob = [
            "robot/archive/library/**",
            "robot/archive/tools/**",
            "robot/archive/config/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="archive_backend",
                    data=ri.SandboxResourceData("ARCHIVE_BACKEND"),
                    build_data=ri.BuildData(
                        target="robot/archive/packages/backend/pkg.json"
                    ),
                    deploy_infos=[
                        ri.single_nanny_service("archive_back_production")
                    ],
                ),
                ri.ReleasableItem(
                    name="archive_backend_configs",
                    data=ri.SandboxResourceData("ARCHIVE_BACKEND_CONFIGS"),
                    build_data=ri.BuildData(
                        target="robot/archive/packages/backend_configs/pkg.json"
                    ),
                    deploy_infos=[
                        ri.single_nanny_service("archive_back_production")
                    ],
                )
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceCIConfig.Notify):
        use_startrek = False  # можно стереть и добавить секцию Startrek, если нужны релизные тикеты

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = None
        dirs = [
            "robot/archive",
        ]
