# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class AuthControllerCfg(configs.ReferenceBranchedConfig):
    name = "auth_controller"
    responsible = "staroverovad"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "DRUG-RELEASERS"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SinglePackagePreset(
                build_apiargs={"requirements": {"disk_space": (10 << 30)}},
                package_names="infra/auth_controller/auth/pkg.json",
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="auth_controller_package",
                    data=ri.SandboxResourceData("AUTH_CONTROLLER_PACKAGE", ttl=30),
                    deploy_infos=[
                        ri.NannyDeployInfo(ri.DeployService("auth_controller_production")),
                        ri.NannyDeployInfo(
                            ri.DeployService("auth_controller_prestable"), stage=rm_const.ReleaseStatus.prestable
                        ),
                    ],
                )
            ]

        release_followers_permanent = [
            "staroverovad",
            "oplachkin",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "staroverovad"
            queue = "AUTHCTLREL"
            dev_queue = "DEPLOY"
            summary_template = u"Приемка auth_controller {}"
            workflow = {}
            followers = [
                "staroverovad",
                "oplachkin",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "infra/auth_controller/releases/"
        observed_paths = [
            "arcadia/infra/auth_controller/auth",
            "arcadia/infra/libs/java/controller",
            "arcadia/yp/java/yp"
        ]
