# -*- coding: utf-8 -*-
import re

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class AutoRu360Poi(configs.ReferenceTaggedConfig):
    name = "autoru360_poi"
    display_name = u"AutoRu360 POI"
    responsible = "woxalex"

    class Releases(configs.ReferenceTaggedConfig.Releases):
        allow_old_releases = True

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="poi_server",
                    data=ri.SandboxResourceData("AUTO_RU_360_POI_EXECUTABLE"),
                    deploy_infos=[ri.single_nanny_service("autoru360_poi")]
                ),
            ]

    class Testenv(configs.ReferenceTaggedConfig.Testenv):
        trunk_task_owner = "CV-RELEASERS"

        class JobGraph(configs.ReferenceTaggedConfig.Testenv.JobGraph):
            @property
            def _tag_part(self):
                tag_part = super(self.__class__, self)._tag_part
                tag_part.append(
                    jg_build.JobGraphElementBuildTagged(
                        task_name="YA_MAKE_2",
                        job_params={
                            "observed_paths": ["cv/verticals/auto_ru/reconstruct_360"],
                            "job_type": rm_const.JobTypes.BUILD,
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        ctx={
                            "build_type": "release",
                            "use_dev_version": False,
                            "targets": "cv/verticals/auto_ru/reconstruct_360/poi_server",
                            "arts": "cv/verticals/auto_ru/reconstruct_360/poi_server/poi_server_auto_reconstruction_360",
                            "test": False,
                            "strip_binaries": True,
                            "result_single_file": True,
                            "result_rt": "AUTO_RU_360_POI_EXECUTABLE"
                        },
                        out={
                            "AUTO_RU_360_POI_EXECUTABLE": 90
                        }
                    )
                )
                return tag_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(jg_release.JobGraphElementNewTagTagged())
                release_part.append(jg_prerelease.JobGraphElementPreliminaryChangelogTagged())
                release_part.append(
                    jg_release.JobGraphElementReleaseTagged(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "poi_server",
                                        "AUTO_RU_360_POI_EXECUTABLE",
                                    )
                                ),
                            ),
                        )
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseTagged(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

    class Notify(configs.ReferenceTaggedConfig.Notify):
        use_startrek = False

        class Telegram(configs.ReferenceTaggedConfig.Notify.Telegram):
            chats = ["cvduty"]

    class ChangelogCfg(configs.ReferenceTaggedConfig.ChangelogCfg):
        wiki_page = ""
        dirs = []
        markers = [
            (4, re.compile(r"(\[AutoRu360 POI\])", flags=re.IGNORECASE)),
            (4, re.compile(r"(\[AutoRu\])", flags=re.IGNORECASE)),
        ]

    class SvnCfg(configs.ReferenceTaggedConfig.SvnCfg):
        tag_name = "autoru360_poi"

    def __init__(self):
        super(AutoRu360Poi, self).__init__()
        self.changelog_cfg = self.ChangelogCfg(self, self.svn_cfg.main_url, self.responsible)
