# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components.job_graph import utils as jg_utils
from sandbox.projects.release_machine.components.job_graph.presets import ci_presets
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri


class AviaAdFeedCfg(configs.ReferenceCIConfig):

    name = "avia_ad_feed"
    description = "Avia Ad Feed"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="ticket"),
        login="liinda",
    )

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "travel/avia/ad_feed"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "AVIA"
        grant_config_update_permissions_to_release_machine_robot = False

        class JobGraph(configs.ReferenceCIConfig.CI.JobGraph):

            _preset = ci_presets.SingleBuildCiPreset(
                build_task_name="YA_MAKE_2",
                build_ctx={
                    "targets": "travel/avia/ad_feed/bin/",
                    "arts": "travel/avia/ad_feed/bin/=ad_feed_bin",
                    "result_rt": "AVIA_AD_FEED_BUNDLE",
                    "result_rd": "Bundle of ad_feed binaries",
                },
                deploy_system=rm_const.DeploySystem.kosher_sandbox_release.name,
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable, jg_utils.Lazy()),
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.testing, jg_utils.Lazy()),
                ],
            )

    class Notify(configs.ReferenceCIConfig.Notify):
        use_startrek = False

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        """
        Changelog configuration

        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """

        observed_paths = ["arcadia/travel/avia/ad_feed"]
        wiki_page = ""

    class Releases(configs.ReferenceCIConfig.Releases):

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="avia_ad_feed_bundle",
                    data=ri.SandboxResourceData("AVIA_AD_FEED_BUNDLE", ttl=20),
                    deploy_infos=[
                        ri.SandboxKosherReleaseInfo(stage=rm_const.ReleaseStatus.stable),
                        ri.SandboxKosherReleaseInfo(stage=rm_const.ReleaseStatus.testing),
                    ],
                )
            ]

        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 10 * 60  # 10 min
