# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import sandbox.projects.release_machine.core.const as rm_const

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.avia import _base_docker_to_deploy
from sandbox.projects.release_machine.core import releasable_items as ri

PROJECT_PATHS = ['arcadia/travel/avia/shared_flights/admin']
LIMIT_DEPENDENCIES_TO = ['arcadia/travel']
PROJECT_PACKAGE_PATH = 'travel/avia/shared_flights/admin/pkg.json'

APPLICATION_RESOURCE_NAME = 'AVIA_SHARED_FLIGHTS_ADMIN_BINARY'

DEPLOY_PROJECT = 'avia-shared-flights'

RESPONSIBLE = 'kurzhumov'
DEVELOPERS = ['mikhailche', 'u-jeen']
MANAGERS = ['kurzhumov']
TESTERS = ['gouken67']

ST_QUEUE = 'RASPTICKETS'
ST_COMPONENT = '$shared-flights-admin'
ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз shared-flights-admin {}'

WIKI_PAGE = 'avia/releases/shared-flights-admin'


class SharedFlightsAdminCfg(configs.ReferenceBranchedConfig):
    display_name = 'Avia Shared Flights Admin'
    name = 'avia_shared_flights_admin'
    responsible = RESPONSIBLE

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = 'AVIA'

        class JobGraph(_base_docker_to_deploy.AviaDockerToDeployJobGraphMixin,
                       configs.ReferenceBranchedConfig.Testenv.JobGraph):
            avia_build_package = PROJECT_PACKAGE_PATH
            avia_project_observed_paths = PROJECT_PATHS
            avia_resource_name = APPLICATION_RESOURCE_NAME
            avia_trunk_auto_deploy_stages = [rm_const.ReleaseStatus.unstable]
            avia_release_button_deploy_stages = [
                rm_const.ReleaseStatus.testing,
                rm_const.ReleaseStatus.stable,
            ]

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=APPLICATION_RESOURCE_NAME,
                    data=_base_docker_to_deploy.get_sandbox_resource_data(APPLICATION_RESOURCE_NAME),
                    deploy_infos=[ri.YaDeployInfo(ri.DeployService(
                        _base_docker_to_deploy.get_deploy_stage_name(rm_const.ReleaseStatus.stable, DEPLOY_PROJECT)
                    ))],
                ),
            ]

        allow_robots_to_release_stable = True
        release_followers_permanent = DEVELOPERS + MANAGERS + TESTERS
        wait_for_deploy_time_sec = 5 * 60  # 5 min
        deploy_system = rm_const.DeploySystem.ya_deploy

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = RESPONSIBLE
            queue = ST_QUEUE
            summary_template = ST_RELEASE_SUMMARY_TEMPLATE
            components = ST_COMPONENT
            followers = DEVELOPERS + MANAGERS + TESTERS
            dev_queue = ST_QUEUE

            hide_commits_under_cut = True

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        ya_make_targets = PROJECT_PATHS
        observed_paths = PROJECT_PATHS
        wiki_page = WIKI_PAGE
        add_to_release_notes = True
        svn_paths_filter = configs.ChangelogPathsFilter(rm_const.PermissionType.ALLOWED, LIMIT_DEPENDENCIES_TO)
