# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import sandbox.projects.release_machine.core.const as rm_const

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.avia import _base_docker_to_deploy
from sandbox.projects.release_machine.core import releasable_items as ri

PROJECT_PATHS = ['arcadia/travel/avia/suggests']
LIMIT_DEPENDENCIES_TO = ['arcadia/travel']
PROJECT_PACKAGE_PATH = 'travel/avia/suggests/pkg.json'

APPLICATION_RESOURCE_NAME = 'AVIA_SUGGESTS_BINARY'

DEPLOY_PROJECT = 'avia-suggests'

RESPONSIBLE = 'liinda'
DEVELOPERS = ['liinda']
MANAGERS = ['kurzhumov']
TESTERS = ['gouken67']

ST_QUEUE = 'RASPTICKETS'
ST_COMPONENT = '$suggests'
ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз suggests {}'

WIKI_PAGE = 'avia/dev/services-table/suggests/releases'


class SuggestsCfg(configs.ReferenceBranchedConfig):
    display_name = 'Avia suggests'
    name = 'avia_suggests'
    responsible = RESPONSIBLE

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = 'AVIA'

        class JobGraph(
                _base_docker_to_deploy.AviaDockerToDeployJobGraphMixin,
                configs.ReferenceBranchedConfig.Testenv.JobGraph,
        ):
            avia_build_package = PROJECT_PACKAGE_PATH
            avia_project_observed_paths = PROJECT_PATHS
            avia_resource_name = APPLICATION_RESOURCE_NAME
            avia_trunk_auto_deploy_stages = [rm_const.ReleaseStatus.unstable]
            avia_wait_for_deploy = True
            avia_wait_for_deploy_time_sec = 10 * 60  # 10 min
            avia_wait_for_deploy_attempts = 6
            avia_use_yt_store = True
            avia_release_button_deploy_stages = [
                rm_const.ReleaseStatus.testing,
                rm_const.ReleaseStatus.stable,
            ]

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=APPLICATION_RESOURCE_NAME,
                    data=_base_docker_to_deploy.get_sandbox_resource_data(APPLICATION_RESOURCE_NAME),
                    deploy_infos=[
                        ri.YaDeployInfo(
                            ri.DeployService(
                                _base_docker_to_deploy.get_deploy_stage_name(
                                    rm_const.ReleaseStatus.stable, DEPLOY_PROJECT
                                )
                            )
                        )
                    ],
                ),
            ]

        allow_robots_to_release_stable = True
        release_followers_permanent = DEVELOPERS + MANAGERS + TESTERS
        deploy_system = rm_const.DeploySystem.ya_deploy

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = RESPONSIBLE
            queue = ST_QUEUE
            summary_template = ST_RELEASE_SUMMARY_TEMPLATE
            components = ST_COMPONENT
            followers = DEVELOPERS + MANAGERS + TESTERS
            dev_queue = ST_QUEUE
            hide_commits_under_cut = True

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        ya_make_targets = PROJECT_PATHS
        observed_paths = PROJECT_PATHS
        wiki_page = WIKI_PAGE
        add_to_release_notes = True
        svn_paths_filter = configs.ChangelogPathsFilter(rm_const.PermissionType.ALLOWED, LIMIT_DEPENDENCIES_TO)

    class SnvCfg(configs.ReferenceBranchedConfig.SvnCfg):
        use_arc = True
