# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import sandbox.projects.release_machine.core.const as rm_const

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.avia import _base

PROJECT_PATHS = ['arcadia/travel/avia/yeah']
LIMIT_DEPENDENCIES_TO = ['arcadia/travel']
PROJECT_PACKAGE_PATH = 'travel/avia/yeah/pkg.json'

APPLICATION_RESOURCE_NAME = 'AVIA_YEAH_BINARY'

QLOUD_APPLICATION = 'yeah'
QLOUD_COMPONENT = 'app'

RESPONSIBLE = 'liinda'
DEVELOPERS = ['liinda']
MANAGERS = ['kurzhumov']
TESTERS = ['gouken67']

ST_QUEUE = 'RASPTICKETS'
ST_COMPONENT = '$yeah'
ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз yeah {}'

WIKI_PAGE = 'avia/dev/services-table/yeah/releases'


class YeahCfg(configs.ReferenceBranchedConfig):
    display_name = 'Avia yeah'
    name = 'avia_yeah'
    responsible = RESPONSIBLE

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = 'AVIA'

        class JobGraph(_base.AviaQloudJobGraphMixin, configs.ReferenceBranchedConfig.Testenv.JobGraph):
            qloud_application = QLOUD_APPLICATION
            qloud_component = QLOUD_COMPONENT
            avia_build_package = PROJECT_PACKAGE_PATH
            avia_project_observed_paths = PROJECT_PATHS
            avia_resource_name = APPLICATION_RESOURCE_NAME
            avia_trunk_auto_deploy_stages = []
            avia_release_button_deploy_stages = [
                rm_const.ReleaseStatus.testing,
                rm_const.ReleaseStatus.stable,
            ]

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name=APPLICATION_RESOURCE_NAME,
                resource_type=APPLICATION_RESOURCE_NAME,
                deploy=[configs.DeployServicesInfo(services=[
                    _base.qloud_environment(rm_const.ReleaseStatus.stable, 'avia', QLOUD_APPLICATION, QLOUD_COMPONENT)
                ])]
            )
        ]
        allow_robots_to_release_stable = True
        release_followers_permanent = DEVELOPERS + MANAGERS + TESTERS
        wait_for_deploy_time_sec = 5 * 60  # 5 min
        deploy_system = rm_const.DeploySystem.qloud

        token_vault_owner = 'AVIA'
        token_vault_name = 'avia-qloud-oauth'

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = RESPONSIBLE
            queue = ST_QUEUE
            summary_template = ST_RELEASE_SUMMARY_TEMPLATE
            components = ST_COMPONENT
            followers = DEVELOPERS + MANAGERS + TESTERS
            dev_queue = ST_QUEUE

            hide_commits_under_cut = True

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        ya_make_targets = PROJECT_PATHS
        observed_paths = PROJECT_PATHS
        wiki_page = WIKI_PAGE
        add_to_release_notes = True
        svn_paths_filter = configs.ChangelogPathsFilter(rm_const.PermissionType.ALLOWED, LIMIT_DEPENDENCIES_TO)
