# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class BalancerCICfg(configs.ReferenceCIConfig):
    name = "balancer_ci"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="appbalancer"),
        login="mmike16",
    )

    class JG(basic_build_presets.SingleBuildYaMakeTemplateJGCfg):
        build_task = "projects/balancer/build_balancer"

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "balancer"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "BALANCER"

        ya_make_abs_paths_glob = [
            "balancer/daemons/**",
            "balancer/kernel/**",
            "balancer/modules/**",
            "balancer/test/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="balancer",
                    data=ri.SandboxResourceData("BALANCER_EXECUTABLE"),
                    deploy_infos=[
                        ri.single_nanny_service("balancer_l7leveler_kubr_man_testing"),
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceCIConfig.Notify):
        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = ["balancer_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "mmike16"
            queue = "BALANCERREL"
            dev_queue = "BALANCER"
            summary_template = u"Приемка балансера {}"
            add_commiters_as_followers = True
            notify_on_deploy_to_feature_st_tickets = True
            deadline = 14
            important_changes_limit = 2000

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "balancer/releases/"
        dirs = [
            "balancer/daemons",
            "balancer/kernel",
            "balancer/modules",
            "balancer/test",
        ]
