# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_job_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


_META_TEST_TARGETS = ";".join([
    "balancer/test/configs/l7heavy_experiments_vla",
    "balancer/test/configs/l7heavy_production_fukraine_man",
    "balancer/test/configs/l7heavy_production_tun_man_only",
    "balancer/test/configs/l7heavy_production_tun_man",
    "balancer/test/configs/l7heavy_production_tun_sas_only",
    "balancer/test/configs/l7heavy_production_tun_sas",
    "balancer/test/configs/l7heavy_production_tun_vla_only",
    "balancer/test/configs/l7heavy_production_tun_vla",
    "balancer/test/configs/l7heavy_production_yaru_man",
    "balancer/test/configs/l7heavy_production_yaru_sas",
    "balancer/test/configs/l7heavy_production_yaru_vla",
    "balancer/test/configs/l7heavy_testing_tun_man",
    "balancer/test/configs/l7heavy_testing_tun_sas",
    "balancer/test/configs/l7heavy_testing_tun_vla",
])


class BalancerConfigCfg(configs.ReferenceBranchedConfig):
    name = "balancer_config"
    responsible = "mmike16"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = "BALANCER"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(
                        ctx={"group_changelog_by_tickets": True}
                    ),
                    jg_prerelease.JobGraphElementWiki(
                        ctx={"group_changelog_by_tickets": True}
                    ),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrekWiki(),
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(jg_build.JobGraphElementBuildBranched(
                    task_name="BUILD_BALANCER_CONFIGS_L7",
                    build_item="BUILD",
                    out={
                        "BALANCER_GENCFG_CONFIGS_L7_TGZ": 180,
                        "BALANCER_GENCFG_CONFIGS_L7_DIR": 180,
                        "BALANCER_L7_YAV_DEPLOY_CONF": 180,
                        "BALANCER_GENCFG_CONFIGS_TEST_TGZ": 180,
                        "BALANCER_GENCFG_CONFIGS_TEST_DIR": 180,
                    },
                ))
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="COMPARE_BALANCER_CONFIGS",
                    ctx={
                        "build_kdiff": True,
                        "hash_markers": True,
                    },
                    job_params={
                        "job_name_parameter": "DIFF",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    job_arrows=[
                        jg_job_arrows.ParamsData("release_number", jg_utils.get_major_release_number),
                        jg_job_arrows.GlobalResourceData("lua_to_json", "LUA_TO_JSON"),
                        jg_job_triggers.JobTriggerBuild(
                            parent_job_data=[
                                jg_job_data.ParentDataResource(
                                    input_key="new",
                                    resource_name="BALANCER_GENCFG_CONFIGS_L7_DIR",
                                ),
                                jg_job_data.ParentDataResource(
                                    input_key="new_yav",
                                    resource_name="BALANCER_L7_YAV_DEPLOY_CONF",
                                ),
                            ],
                            job_name_parameter="BUILD",
                        ),
                    ],
                ))
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name='BALANCER_LOAD_COMPARE',
                        job_params={
                            'test_type': jg_utils.TestType.CHECK_TEST,
                            'job_name_parameter': 'LOAD',
                            'frequency': (jg_utils.TestFrequency.EVERY_N_COMMIT, 1000),
                        },
                        ctx={
                            'binary_old': 'sandbox',
                            'binary_new': 'sandbox',
                            'release_component': 'balancer_config',
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key='configs_new',
                                        resource_name='BALANCER_GENCFG_CONFIGS_TEST_DIR',
                                    ),
                                ),
                                job_name_parameter='BUILD',
                            ),
                            jg_job_arrows.ParamsData('release_number', jg_utils.get_major_release_number),
                        ),
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementMetaTestBranched(
                        job_params={
                            "job_name_parameter": "META_TESTS",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            "apiargs": {
                                # "requirements": {
                                #     "disk_space": 120 * (1024 ** 3),  # 120 Gb
                                # },
                                "kill_timeout": 2 * 60 * 60,  # 2 hour
                            }
                        },
                        ctx={
                            "targets": _META_TEST_TARGETS,
                            "test": True,
                            "disable_test_timeout": True,
                            # "ya_timeout": 15 * 6 * 60,
                        },
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_stage = rm_const.ReleaseStatus.stable
                release_part.append(jg_release.JobGraphElementReleaseBranched(
                    release_to=release_stage,
                    job_arrows=[
                        jg_job_triggers.JobTriggerBuild(
                            [
                                jg_job_data.ParentDataDict(
                                    "component_resources", "balancer_configs_tgz", "BALANCER_GENCFG_CONFIGS_L7_TGZ"
                                )
                            ],
                            job_name_parameter="BUILD"
                        ),
                        jg_job_triggers.JobTriggerNewTag([
                            jg_job_data.ParentDataCtx("major_release_num", "branch_number_for_tag"),
                            jg_job_data.ParentDataCtx("minor_release_num", "new_tag_number"),
                            jg_job_data.ParentDataCtx("release_number", "scope_number", override=True),
                        ]),
                    ],
                ))
                release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                    release_to=release_stage,
                    job_arrows=[
                        jg_job_triggers.JobTriggerRelease(job_name_parameter=release_stage),
                    ],
                ))
                return release_part

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        """Release viewer configuration"""
        kpi_alert = 6
        kpi_alert_skip_weekends = True

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="balancer_configs_tgz",
                resource_type="BALANCER_GENCFG_CONFIGS_L7_TGZ",
                deploy=[(rm_const.ReleaseStatus.stable, "balancer_l7leveler_kubr_vla")],
            ),
        ]
        release_followers_permanent = [
            "dmitryno",
            "mmike16",
        ]
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        notifications = [
            rm_notifications.Notification(
                event_type="MergeCommit",
                chat_name="balancer_config_comp",
                conditions=rm_notifications.NotificationCondition(conditions=[], join_strategy="OR"),
            ),
            rm_notifications.Notification(
                event_type="NewBranch",
                chat_name="balancer_config_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewTag",
                chat_name="balancer_config_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TestenvDbClone",
                chat_name="balancer_config_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewWikiPage",
                chat_name="balancer_config_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="balancer_config_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="BuildTest",
                chat_name="balancer_config_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="KpiAlert",
                chat_name="balancer_config_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="ReleaseFailed",
                chat_name="balancer_config_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name="balancer_config_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseDeployed",
                chat_name="balancer_config_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_deployed_oldschool.html",
            ),
        ]

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            """Mail notifications configuration"""

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = ["balancer_config_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "mmike16"
            queue = "BALANCERCFGREL"
            dev_queue = "MINOTAUR"
            summary_template = u"Приемка balancer config {}"
            workflow = {}
            add_commiters_as_followers = True
            notify_on_deploy_to_feature_st_tickets = True
            deadline = 14
            important_changes_limit = 2000

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "L7/config-releases/"
        dirs = [
            "arcadia/gencfg/custom_generators/balancer_gencfg/configs/any",
            "arcadia/gencfg/custom_generators/balancer_gencfg/configs/l7heavy",
            "arcadia/gencfg/custom_generators/balancer_gencfg/gen-configs-l7-balancer.sh",
            "arcadia/gencfg/custom_generators/balancer_gencfg/src",
        ]
        review_groups = [
            "balancer_config",
        ]
