# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class BalancerConfigCICfg(configs.ReferenceCIConfig):
    name = "balancer_config_ci"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="appbalancer"),
        login="mmike16",
    )

    class JG(basic_build_presets.SingleBuildYaMakeTemplateJGCfg):
        build_task = "projects/balancer/build_balancer_config"

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "balancer/config"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "BALANCER"

        ya_make_abs_paths_glob = [
            "balancer/config/**",
            "balancer/test/configs/**",
            "gencfg/custom_generators/balancer_gencfg/configs/l7heavy/**",
            "gencfg/custom_generators/balancer_gencfg/src/**",
            "gencfg/custom_generators/balancer_gencfg/utils/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="balancer_config",
                    data=ri.SandboxResourceData("BALANCER_GENCFG_CONFIGS_L7_TGZ"),
                    deploy_infos=[
                        ri.single_nanny_service("balancer_l7leveler_kubr_man_testing"),
                    ],
                ),
                ri.ReleasableItem(
                    name="balancer_yav_deploy_conf",
                    data=ri.SandboxResourceData("BALANCER_L7_YAV_DEPLOY_CONF"),
                    deploy_infos=[
                        ri.single_nanny_service("balancer_l7leveler_kubr_man_testing"),
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceCIConfig.Notify):
        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = ["balancer_config_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "mmike16"
            queue = "BALANCERCFGREL"
            dev_queue = "MINOTAUR"
            summary_template = u"Приемка конфига балансера {}"
            add_commiters_as_followers = True
            notify_on_deploy_to_feature_st_tickets = True
            deadline = 14
            important_changes_limit = 2000

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "L7/config-releases/"
        dirs = [
            "balancer/config",
            "balancer/test/configs",
            "gencfg/custom_generators/balancer_gencfg/configs/l7heavy",
            "gencfg/custom_generators/balancer_gencfg/src",
            "gencfg/custom_generators/balancer_gencfg/utils",
        ]
