# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components.configs.basesearch import notifications_template, workflow_template
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.common.constants import constants as common_const
import sandbox.projects.release_machine.components.config_core.statistics_page as statistics_page
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


_META_TEST_TARGETS = ";".join([
    "saas/rtyserver_test/tests",
])


class BaseCfg(configs.ReferenceBranchedConfig):
    name = "base"
    display_name = u"Web Basesearch"
    responsible = "salmin"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_db = "ws-base-trunk"
        trunk_task_owner = "SEARCH-RELEASERS"
        branch_db_template = "ws-base-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _trunk_part(self):
                resource_type = "BASESEARCH_EXECUTABLE"
                main_def_flags = " ".join([
                    "-DHAVE_CUDA=no",
                    '-DCFLAGS="-mllvm -inline-threshold=1000 -fno-omit-frame-pointer"'
                ])
                debug_def_flags = "-DSIMPLE_COUNTER_THREAD_CHECK=yes"
                trunk_build_job_params = {
                    "tags": [jg_utils.Tag.LIGHT_PRECOMMIT_CHECKS],
                    "should_add_to_db": {
                        "trunk": jg_utils.should_add_to_db_trunk,
                        "branch": jg_utils.should_add_to_db_branch,
                    },
                    "frequency": {
                        "trunk": (jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 10),
                        "branch": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                }
                check_deps = {
                    "check_dependencies": True,
                    "banned_dependencies": ",".join([
                        "kikimr/",
                        "dict/dictutil/",
                    ]),
                    "whitelisted_dependencies": ",".join([
                        "kikimr/library/aclib/protos/",
                        "kikimr/public/api/protos/",
                        "kikimr/public/api/protos/annootations/",
                        "kikimr/streaming/libs/config/proto/",
                        "kikimr/streaming/libs/control_plane/proto/public/",
                    ]),
                }
                filter_targets = [
                    "search/daemons/basesearch",
                    "build/ya.conf.json",
                ]
                return [
                    jg_build.JobGraphElementBuildTrunk(
                        task_name="BUILD_BASESEARCH_3",
                        job_params=trunk_build_job_params,
                        ctx=dict(
                            {
                                common_const.BUILD_TYPE_KEY: common_const.RELEASE_BUILD_TYPE,
                                common_const.DEFINITION_FLAGS_KEY: main_def_flags,
                                "target_resources": resource_type,
                            },
                            **check_deps
                        ),
                        out={resource_type: 35},
                        filter_targets=filter_targets,
                    ),
                    jg_build.JobGraphElementBuildTrunk(
                        task_name="BUILD_BASESEARCH_3",
                        job_params=trunk_build_job_params,
                        build_item="DEBUG",
                        ctx={
                            common_const.BUILD_TYPE_KEY: common_const.DEBUG_BUILD_TYPE,
                            common_const.DEFINITION_FLAGS_KEY: debug_def_flags,
                            "target_resources": resource_type,
                        },
                        out={resource_type: 35},
                        filter_targets=filter_targets,
                    ),
                ] + [
                    jg_build.JobGraphElementBuildTrunk(
                        task_name="BUILD_BASESEARCH_3",
                        job_params=dict(
                            trunk_build_job_params,
                            frequency={
                                "trunk": (jg_utils.TestFrequency.LAZY, None),
                                "branch": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            }
                        ),
                        build_item=build_item,
                        ctx={
                            common_const.BUILD_TYPE_KEY: common_const.RELEASE_BUILD_TYPE,
                            common_const.SANITIZE: sanitizer,
                            "target_resources": resource_type,
                        },
                        out={resource_type: 35},
                        filter_targets=filter_targets,
                    ) for build_item, sanitizer in [
                        ("ASAN", "address"),
                        ("MSAN", "memory"),
                        ("TSAN", "thread"),
                        ("LSAN", "leak"),
                        ("UBSAN", "undefined"),
                    ]
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name="BUILD_BASESEARCH_AND_RTY",
                        job_params={
                            "job_name_parameter": "AND_RTY",
                        },
                        ctx={
                            "notify_if_failed": "SEARCH-RELEASERS",
                            common_const.MUSL: True,
                            common_const.BUILD_SYSTEM_KEY: "semi_distbuild",
                            "build_rty_server": True,
                            common_const.CLEAR_BUILD_KEY: False,
                            "use_fuse": True,
                            common_const.THINLTO: True,
                            common_const.DEFINITION_FLAGS_KEY: (
                                "-DHAVE_CUDA=no -DCFLAGS=\"-mllvm -inline-threshold=1000 -fno-omit-frame-pointer\""
                            ),
                            "ymake_parameters": "-DCFLAGS=\"-fno-omit-frame-pointer\"",
                        },
                        out={"BASESEARCH_EXECUTABLE": 90, "RTYSERVER": 90},
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="web",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "base_executable_res_id",
                                        "BASESEARCH_EXECUTABLE",
                                    ),
                                ),
                                job_name_parameter="AND_RTY",
                            ),
                        ),
                        ctx={
                            "beta_name_source": "STRING",
                            "patch_name": "priemka",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="quick",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "rty_server_executable_res_id",
                                        "RTYSERVER",
                                    ),
                                ),
                                job_name_parameter="AND_RTY",
                            ),
                        ),
                        ctx={
                            "beta_name_source": "STRING",
                            "patch_name": "acceptance",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="news",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "rty_server_executable_res_id",
                                        "RTYSERVER",
                                    ),
                                ),
                                job_name_parameter="AND_RTY",
                            ),
                        ),
                        ctx={
                            "beta_name_source": "STRING",
                            "patch_name": "news_beta",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementLaunchMetrics(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="checked_beta",
                                        output_key="beta_name",
                                        transform=lambda x, params: "{}.hamster".format(x),
                                    ),
                                ),
                                job_name_parameter="WEB",
                            ),
                        ),
                        ctx={
                            "custom_template_name": "common.json",
                            "sample_beta": "hamster",
                            "scraper_over_yt_pool": "base_web_priemka",
                        }
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementLaunchMetrics(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="checked_beta",
                                        output_key="new_beta_url"
                                    ),
                                ),
                                job_name_parameter="NEWS",
                            ),
                        ),
                        job_params={
                            "job_name_parameter": "NEWS_METRICS",
                        },
                        search_subtype="news",
                        ctx={
                            "custom_template_name": "news_runtime_acceptance.json",
                            "sample_beta": "saas-news-beta2.news.stable.priemka"  # baseline
                        }
                    )
                )

                branch_part.append(
                    jg_test.JobGraphElementTestTdiAndRearr(
                        job_params={
                            "job_name_parameter": "LAUNCH_REARRANGE_ACCEPTANCE_QUICK",
                            "ctx": {
                                "launch_new_RA_for_blender_and_video": False,
                                "launch_new_RA_for_blender_on_desktop": False,
                                "launch_new_RA_for_blender_on_touch": False,
                                "launch_new_RA_for_blender_on_pad": False,
                                "launch_new_RA_for_people": False,
                                "launch_new_RA_for_people_wizard": False,
                                "launch_new_RA_for_people_vertical": False,
                                "launch_images_RA": False,
                                "launch_video_RA": False,
                                "launch_videoserp_RA": False,
                                "launch_personalization_RA2": False,
                                "launch_quick_RA2": True,
                                "run_count": 2,
                                "scraper_over_yt_pool": "base_web_priemka",
                                "sample_beta": "saas-refresh-baseline.hamster",
                            },
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="checked_beta",
                                        output_key="beta_name",
                                        transform=lambda x, params: "{}.hamster".format(x),
                                    ),
                                ),
                                job_name_parameter="quick",
                            ),
                        )
                    ),
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="PRIEMKA_BASESEARCH_BINARY",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        "build_task_id",
                                    ),
                                ),
                                job_name_parameter="AND_RTY",
                            ),
                            jg_arrows.ParamsData(
                                input_key="release_number",
                                transform=jg_utils.get_major_release_number,
                            ),
                            jg_arrows.ParamsData(
                                input_key="revision_tested",
                                transform=lambda params, rm_config: params.revision,
                            ),
                        ),
                        job_params={
                            "job_name_parameter": "DAILY_PRIEMKA",
                            "frequency": (jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 42),
                        },
                        ctx={
                            "plan_types_for_perf_tests": "search factors",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestXMLSearch(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="beta_url",
                                        output_key="beta_name",
                                        transform=lambda x, params: "https://{}.hamster.yandex.ru".format(x),
                                    ),
                                ),
                                job_name_parameter="WEB",
                            ),
                        ),
                        job_name_parameter="PRIEMKA",
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="RUN_FUSION_PRODUCTION_ENV",
                        job_params={
                            "job_name_parameter": "REFRESH_FUSION",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="rtyserver_binary",
                                        resource_name="RTYSERVER",
                                    ),
                                ),
                                job_name_parameter="AND_RTY",
                            ),
                        ),
                        ctx={
                            "nanny_service_name": "saas_yp_samohod",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementMetaTestBranched(
                        job_params={
                            "job_name_parameter": "META_TESTS",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            "apiargs": {
                                "kill_timeout": 2 * 60 * 60,  # 2 hour
                            }
                        },
                        ctx={
                            "targets": _META_TEST_TARGETS,
                            "disable_test_timeout": True,
                        },
                    )
                )
                umbrella_tests = (
                    jg_job_triggers.JobTriggerLaunchMetrics(
                        job_name_parameter="WEB",
                    ),
                    jg_job_triggers.JobTriggerLaunchMetrics(
                        job_name_parameter="NEWS_METRICS",
                    ),
                    jg_job_triggers.JobTriggerTestBranchCommon(
                        job_name_parameter="DAILY_PRIEMKA",
                    ),
                    jg_job_triggers.JobTriggerTestXMLSearch(
                        job_name_parameter="PRIEMKA",
                    ),
                    jg_job_triggers.JobTriggerTestBranchCommon(
                        job_name_parameter="REFRESH_FUSION",
                    ),
                    jg_job_triggers.JobTriggerTestTdiAndRearr(
                        job_name_parameter="LAUNCH_REARRANGE_ACCEPTANCE_QUICK",
                    ),
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                        job_arrows=umbrella_tests,
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedScheduled(
                        job_arrows=umbrella_tests,
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="base_executable_res_id",
                                        resource_name="BASESEARCH_EXECUTABLE",
                                    ),
                                ),
                                job_name_parameter="AND_RTY",
                            ),
                        ),
                        release_item="AND_RTY",
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="AND_RTY",
                    )
                )
                return release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            @property
            def change_frequency(self):
                uppercase_name = self.name.upper()
                tests = super(self.__class__, self).change_frequency
                tests.update({
                    "_{}_AND_RTY_DAILY_PRIEMKA".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_{}_DAILY_PRIEMKA".format(uppercase_name): rm_const.TestFrequencies.FORTY_TWO_TEST,
                    "_BUILD_RELEASE_{}SEARCH_AND_RTY".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                })
                return tests

            @property
            def ignore_prefix(self):
                return super(self.__class__, self).ignore_prefix + [
                    "TEST_DEPLOY_MANAGER_",
                    "WEB_FUZZY",
                    "WEB_BASE_FUZZY",
                ]

            @property
            def ignore_match(self):
                common_ignored = super(self.__class__, self).ignore_match
                return common_ignored + [
                    "TEST_XML_SEARCH_PRIEMKA",  # this test has analogue in branch bases
                ]

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        kpi_alert = 4
        statistics_page_charts = statistics_page.DEFAULT + [statistics_page.PredefinedCharts.TIMESPECTRE_METRICS]

    class Releases(configs.ReferenceBranchedConfig.Releases):
        resources_info = [
            configs.ReleasedResourceInfo(
                name="base",
                resource_type="BASESEARCH_EXECUTABLE",
                resource_name="base_executable_res_id",
                deploy=[(rm_const.ReleaseStatus.stable, "nightlybaseline_jupiter_base")],
            ),
            configs.ReleasedResourceInfo(
                name="rty_server_executable_res_id",
                resource_type="RTYSERVER",
            ),
        ]
        allow_robots_to_release_stable = True
        responsible = configs.Responsible(
            abc=configs.Abc(component_id=3429, schedule_slug="cajuper"),
            login="salmin",
        )
        allow_old_releases = True  # TODO remove after stable-462 deploy

    class Notify(configs.ReferenceBranchedConfig.Notify):
        notifications = notifications_template

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["base_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = u"https://t.me/joinchat/CaUODkKTwtMdwenQIkLLKQ"

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "amatveyev"
            queue = "BASEREL"
            dev_queue = "SEARCH"
            summary_template = u"Приемка базового поиска {}"
            components = u"Базовый поиск".encode("utf-8")
            workflow = workflow_template
            followers = [
            ]
            commit_importance_threshold = 2
            add_commiters_as_followers = False
            use_task_author_as_assignee = True
            deadline = 7
            nanny_reports = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "jandekspoisk/kachestvopoiska/basesearch/releases/"
        ya_make_targets = [
            "arcadia/search/daemons/basesearch",
            "arcadia/saas/rtyserver",
        ]
        review_groups = [
            "base",
        ]
        svn_paths_filter = configs.ChangelogPathsFilter(
            rm_const.PermissionType.BANNED, [
                "arcadia/market",
                "arcadia/dict",
                "arcadia/dj",
                "arcadia/kikimr",
                "arcadia/yt",
            ])

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "web": yappy_cfg.YappyTemplateCfg(
                template_name="base-web",  # TODO: Set beta name
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="base-web",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="basesearch.executable",
                                param_name="base_executable_res_id",
                                checkconfig_name="base-linux-bin-md5",
                            ),
                            yappy_cfg.YappyStaticResource(local_path="basesearch.models", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="mmeta.executable", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="mmeta.models", manage_type="BC_DEFAULT"),
                        ],
                    )
                ],

            ),
            "quick": yappy_cfg.YappyBetaCfg(
                beta_name="saas-refresh-acceptance",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyBetaPatch(
                        patch_file="saas-refresh-acceptance",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="basesearch.executable", param_name="rty_server_executable_res_id"
                            ),
                            yappy_cfg.YappyStaticResource(local_path="basesearch.models", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(
                                local_path="basesearch.static_models", manage_type="BC_DEFAULT"
                            ),
                            yappy_cfg.YappyStaticResource(local_path="mmeta.executable", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="mmeta.models", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="mmeta.rearrange", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyLastReleasedResource(
                                local_path="basesearch.config", res_type="SAAS_RTYSERVER_CONFIGS_BUNDLE"
                            ),
                        ]
                    )
                ]
            ),
            "news": yappy_cfg.YappyBetaCfg(
                beta_name="saas-news-beta1",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyBetaPatch(
                        patch_file="saas-news-base",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="basesearch.executable", param_name="rty_server_executable_res_id"
                            ),
                            yappy_cfg.YappyStaticResource(local_path="basesearch.models", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(
                                local_path="basesearch.static_models", manage_type="BC_DEFAULT"
                            ),
                            yappy_cfg.YappyStaticResource(local_path="mmeta.executable", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="mmeta.models", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="mmeta.rearrange", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyLastReleasedResource(
                                local_path="basesearch.config", res_type="SAAS_RTYSERVER_CONFIGS_BUNDLE"
                            ),
                        ]
                    )
                ]
            )
        }
