from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications

notifications_template = [
    rm_notifications.Notification(
        event_type="NewBranch",
        chat_name="base_comp",
        conditions=rm_notifications.NotificationCondition(
            conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
            join_strategy="OR",
        ),
    ),
    rm_notifications.Notification(
        event_type="NewTag",
        chat_name="base_comp",
        conditions=rm_notifications.NotificationCondition(
            conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
            join_strategy="OR",
        ),
    ),
    rm_notifications.Notification(
        event_type="TestenvDbClone",
        chat_name="base_comp",
        conditions=rm_notifications.NotificationCondition(
            conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
            join_strategy="OR",
        ),
    ),
    rm_notifications.Notification(
        event_type="NewWikiPage",
        chat_name="base_comp",
        conditions=rm_notifications.NotificationCondition(
            conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
            join_strategy="OR",
        ),
    ),
    rm_notifications.Notification(
        event_type="TicketHistory",
        chat_name="base_comp",
        conditions=rm_notifications.NotificationCondition(
            conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
            join_strategy="OR",
        ),
    ),
    rm_notifications.Notification(
        event_type="BuildTest",
        chat_name="base_comp",
        conditions=rm_notifications.NotificationCondition(
            conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
            join_strategy="OR",
        ),
    ),
    rm_notifications.Notification(
        event_type="KpiAlert",
        chat_name="base_comp",
        conditions=rm_notifications.CONDITION_ALWAYS,
    ),
    rm_notifications.Notification(
        event_type="NewBetaGeneration",
        chat_name="base_comp",
        conditions=rm_notifications.NotificationCondition(
            conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
            join_strategy="OR",
        ),
    ),
    rm_notifications.Notification(
        event_type="ReleaseFailed",
        chat_name="base_comp",
        conditions=rm_notifications.CONDITION_ALWAYS,
    ),
    rm_notifications.Notification(
        event_type="MergeCommit",
        chat_name="base_comp",
        conditions=rm_notifications.CONDITION_ALWAYS,
    ),
    rm_notifications.Notification(
        event_type="TicketHistory",
        chat_name="base_comp",
        conditions=rm_notifications.NotificationCondition(
            conditions=rm_notifications.STARTREK_TICKET_CREATED_CONDITIONS,
            join_strategy="OR",
        ),
        message_template_file="notifications/ticket_created.html",
    ),
    rm_notifications.Notification(
        event_type="ReleaseDeployed",
        chat_name="base_comp",
        conditions=rm_notifications.CONDITION_ALWAYS,
        message_template_file="notifications/release_deployed_oldschool.html",
    ),
    rm_notifications.Notification(
        event_type="ReleaseCreated",
        chat_name="base_comp",
        conditions=rm_notifications.CONDITION_ALWAYS,
        message_template_file="notifications/release_created_oldschool.html",
    ),
]

workflow_template = {
    "open": "autoTesting",
    "fixProblems": "accepting",
    "production": "close",
    "closed": "reopen",
    "qualityOK": "deploying",
    "accepting": "qualityOK",
    "autoTesting": "autoTestsOK",
    "autoTestsOK": "accepting",
    "deploying": "production",
}
