# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.common.constants import constants as sandbox_consts
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


IGNORED_BRANCH_TESTS = [
    "_BASS_TESTPALM_TEST",
    "BUILD_BASS_CHECK",
]


class BassCfg(configs.ReferenceBranchedConfig):
    name = "bass"
    responsible = "avitella"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "BASS"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementWiki(),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="BASS_REGRESS_TESTS_TASK",
                        job_params={
                            "job_name_parameter": "TESTPALM_TEST",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerStartrek(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="target_ticket",
                                        output_key="startrek_issue",
                                        transform=lambda x, params: "{}".format(x),
                                    ),
                                )
                            )
                        ),
                        ctx={
                            "target_service": "BASS",
                            "testsuite": "alice",
                        },
                    ),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrekWiki(
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="TESTPALM_TEST",
                            )
                        )
                    ),
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                for build_item in [sandbox_consts.RELEASE_BUILD_TYPE, sandbox_consts.DEBUG_BUILD_TYPE]:
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="BUILD_BASS",
                            build_item=build_item,
                            job_params={
                                "apiargs": {"requirements": {"disk_space": 112640}},
                            },
                            job_arrows=(
                                jg_arrows.ParamsData(
                                    input_key="rev",
                                    transform=lambda x, rm_config: x.revision,
                                ),
                            ),
                            ctx={
                                "test": True,
                                "test_tag": "-bass_ydb_flapping_test",
                                "release_type": "rc" if build_item == sandbox_consts.DEBUG_BUILD_TYPE else "production",
                            },
                            out={
                                "BASS_BIN": 90,
                                "BASS_CONFIG": 90,
                                "BASS_PIPE_LOG_PARSER": 90,
                            },
                        )
                    )
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="beta",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter=sandbox_consts.RELEASE_BUILD_TYPE,
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "bass_bin",
                                        "BASS_BIN",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "bass_config",
                                        "BASS_CONFIG",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "bass_pipe_log_parser",
                                        "BASS_PIPE_LOG_PARSER",
                                    ),
                                )
                            ),
                            jg_job_triggers.JobTriggerChangelogFinal(),
                        ),
                        ctx={"beta_name_source": "STRING"},
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="BASS_VINS_TESTS_TASK",
                        job_params={
                            "job_name_parameter": "INTEGRATION_TEST",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter=sandbox_consts.RELEASE_BUILD_TYPE,
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="verbose_release_id",
                                        output_key="ap_arcadia_tag",
                                        transform=lambda x, params: "{}".format(x),
                                    )
                                )
                            ),
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                            ),
                            jg_arrows.ParamsData("release_number", jg_utils.get_major_release_number),
                        ),
                        ctx={
                            "vins_url": "http://yappy_vins_hamster_0.yappy-slots.yandex-team.ru/speechkit/app/pa/",
                            "minimalistic_comments": 1,
                        }
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedScheduled(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="INTEGRATION_TEST",
                            ),
                        ),
                        frequency=(jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 42),
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage, build_item in [
                    (rm_const.ReleaseStatus.stable, sandbox_consts.RELEASE_BUILD_TYPE),
                    (rm_const.ReleaseStatus.unstable, sandbox_consts.DEBUG_BUILD_TYPE),
                ]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter=build_item,
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources", "bass_bin", "BASS_BIN",
                                        ),
                                        jg_job_data.ParentDataDict(
                                            "component_resources", "bass_config", "BASS_CONFIG",
                                        ),
                                        jg_job_data.ParentDataDict(
                                            "component_resources", "bass_pipe_log_parser", "BASS_PIPE_LOG_PARSER",
                                        ),
                                    ),
                                )
                            )
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                        )
                    )
                return release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                uppercase_name = self.name.upper()
                tests.update({
                    "_{}_UMBRELLA_ACCEPT_SCHEDULED".format(uppercase_name): rm_const.TestFrequencies.FORTY_TWO_TEST,
                })
                return tests

            @property
            def ignore_match(self):
                return super(self.__class__, self).ignore_match + IGNORED_BRANCH_TESTS

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="bass_bin",
                    data=ri.SandboxResourceData("BASS_BIN"),
                ),
                ri.ReleasableItem(
                    name="bass_config",
                    data=ri.SandboxResourceData("BASS_CONFIG"),
                ),
                ri.ReleasableItem(
                    name="bass_pipe_log_parser",
                    data=ri.SandboxResourceData("BASS_PIPE_LOG_PARSER"),
                ),
            ]
        wait_for_deploy_time_sec = 3600

    class Notify(configs.ReferenceBranchedConfig.Notify):
        notifications = [
            rm_notifications.Notification(
                event_type="MergeCommit",
                chat_name="bass_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewBranch",
                chat_name="bass_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewTag",
                chat_name="bass_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TestenvDbClone",
                chat_name="bass_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewWikiPage",
                chat_name="bass_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="bass_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="KpiAlert",
                chat_name="bass_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="NewBetaGeneration",
                chat_name="bass_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="ReleaseFailed",
                chat_name="bass_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="bass_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.STARTREK_TICKET_CREATED_CONDITIONS,
                    join_strategy="OR",
                ),
                message_template_file="notifications/ticket_created.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name="bass_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseDeployed",
                chat_name="bass_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_deployed_oldschool.html",
            ),
        ]

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = [
                "bass-releases@yandex-team.ru",
            ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["bass_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = "https://t.me/joinchat/AAAAAEUzgJcHCRaSP_o0cw"

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "avitella"
            queue = "ALICERELEASE"
            dev_queue = "ALICE"
            summary_template = u"Релиз Bass {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "m-karlina",
                "okras",
            ]
            add_commiters_as_followers = False
            deadline = 7
            hide_commits_under_cut = True
            important_changes_limit = 100

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = ""
        dirs = [
            "arcadia/alice/bass",
        ]
        review_groups = [
            "cards_service",
        ]

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "beta": yappy_cfg.YappyBetaCfg(
                beta_name="alice-bass-rm",
                patches=[
                    yappy_cfg.YappyBetaPatch(
                        patch_file="alice/bass/alice-bass-rm",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(param_name="bass_bin", local_path="cards_service"),
                            yappy_cfg.YappyParametrizedResource(param_name="bass_config", local_path="config"),
                            yappy_cfg.YappyStaticResource(
                                local_path="Conf.local",
                                manage_type="STATIC_CONTENT",
                                content="ENV_CONFIG_FILE=./config/config/rc_config.json",
                            ),
                        ],
                        parent_service="bass_man",
                    )
                ]
            )
        }
