# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri

import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils

from sandbox.projects.common.constants import constants as common_const

BUILD_TRUNK_RESOURCES = (
    {
        "name": "begemot",
        "type": "BEGEMOT_ADVQ_EXECUTABLE",
    },
    {
        "name": "fast_build_config.json",
        "type": "BEGEMOT_FAST_BUILD_CONFIG_ADVQ",
    },
    {
        "name": "evlogdump",
        "type": "BEGEMOT_EVLOGDUMP",
    },
)

BUILD_RESOURCES = BUILD_TRUNK_RESOURCES + (
    {
        "name": "bstr",
        "type": "BEGEMOT_BSTR",
    },
    {
        "name": "bstr_caller",
        "type": "BEGEMOT_BSTR_CALLER",
    },
    {
        "name": "eventlog_uploader",
        "type": "BEGEMOT_EVLOG_UPLOADER",
    },
    {
        "name": "fast_build_data_downloader",
        "type": "BEGEMOT_FAST_BUILD_DOWNLOADER",
    },
    {
        "name": "fast_data_callback",
        "type": "BEGEMOT_FAST_DATA_CALLBACK",
    },
    {
        "name": "instancectl.conf",
        "type": "BEGEMOT_INSTANCECTL_CONF",
    },
    {
        "name": "worker.cfg",
        "type": "BEGEMOT_CONFIG",
    },
    {
        "name": "args",
        "type": "BEGEMOT_ARGUMENTS_PARSER",
    },
)

NANNY_SERVICES = [
    "begemot_advq_prod_sas",
    "begemot_advq_prod_man",
    "begemot_advq_prod_vla",
]


class BegemotAdvqCfg(cfg.ReferenceBranchedConfig):
    name = "begemot_advq"
    display_name = "Begemot Advq"
    responsible = "gluk47"

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "ADVQ"

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrek(
                        next_revision_custom_schedule=jg_utils.CustomSchedule(
                            time_interval_list=[(7, 9)],
                            weekday_list=[0, 3],
                            last_run_finished=True,
                            once_a_day=True
                        )
),
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part

                out = {res["type"]: 30 for res in BUILD_RESOURCES}
                out.update({"BEGEMOT_STABLE_RELEASE_CONFIG": 30})
                branch_part.append(jg_build.JobGraphElementBuildBranched(
                    task_name="RELEASE_BEGEMOT_ADVQ_RESOURCES",
                    job_params={
                        "task_priority": 7,
                    },
                    build_item=common_const.RELEASE_BUILD_TYPE,
                    ctx={
                        "all_resources": False,
                        "begemot_resources": "BegemotConfig AdvqExecutable Bstr Advq NannyConfigs",
                        common_const.BUILD_TYPE_KEY: common_const.RELEASE_BUILD_TYPE,
                        common_const.USE_AAPI_FUSE: True,
                        "need_stable_release_config": True,
                        "begemot_stable_services_dashboard": "begemot_advq",
                    },
                    out=out,
                ))
                return branch_part

            @property
            def _release(self):
                return super(self.__class__, self)._release + [
                    jg_release.JobGraphElementReleasePushBranched(
                        task_name="RELEASE_RM_COMPONENT_2",
                        release_to=rm_const.ReleaseStatus.stable,
                        job_params={
                            "task_priority": 7,
                            "ctx": {
                                "deploy_system": rm_const.DeploySystem.nanny_push.name,
                            }
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=jg_job_data.ParentDataDict(
                                    "component_resources",
                                    "scheduled_bundle",
                                    "BEGEMOT_STABLE_RELEASE_CONFIG",
                                ),
                                job_name_parameter=common_const.RELEASE_BUILD_TYPE,
                            ),
                            jg_job_triggers.JobTriggerNewTag([
                                jg_job_data.ParentDataOutput('major_release_num', 'branch_number_for_tag'),
                                jg_job_data.ParentDataOutput('minor_release_num', 'new_tag_number'),
                            ]),
                        )
                    ),
                    jg_release.JobGraphElementActionPushReleaseBranched(rm_const.ReleaseStatus.stable),
                ]

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "abordonos"
            queue = "ADVQRELEASES"
            summary_template = u"Приемка Begemot Advq {}"
            add_commiters_as_followers = True
            deadline = 7

            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }

            use_task_author_as_assignee = False
            write_merges_in_table = True

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = ""
        dirs = [
            "arcadia/search/daemons/begemot/advq",
            "arcadia/search/begemot/core",
            "arcadia/search/begemot/data/Advq",
            "arcadia/search/begemot/rules/advq_synonyms",
            "arcadia/search/wizard/data/wizard/AdvqSynonyms",
        ]

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        max_active_branches = 4

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        deploy_system = rm_const.DeploySystem.nanny_push
        allow_to_remove_resources = True
        allow_old_releases = True

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    'begemot',
                    ri.SandboxResourceData('BEGEMOT_ADVQ_EXECUTABLE'),
                    deploy_infos=[ri.NannyDeployInfo([ri.DeployService(i, tags=["prod"]) for i in NANNY_SERVICES])],
                ),
                ri.DynamicReleasableItem(
                    'scheduled_bundle',
                    ri.SandboxResourceData('BEGEMOT_STABLE_RELEASE_CONFIG'),
                    [ri.NannyDeployInfo()],
                ),
            ]

        release_followers_permanent = [
            "abordonos",
        ]
        wait_for_deploy_time_sec = 4 * 60 * 60
        allow_robots_to_release_stable = True
