# -*- coding: utf-8 -*-

from sandbox.projects.common import constants as sandbox_constants
from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri

import sandbox.projects.release_machine.components.config_core.statistics_page as statistics_page
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils

from sandbox.projects.release_machine.components.configs.report import SearchIntergationTestBundle


BUILD_TRUNK_RESOURCES = (
    {
        "name": "begemot",
        "type": "BEGEMOT_REQUEST_INIT_EXECUTABLE",
    },
    {
        "name": "fast_build_config.json",
        "type": "BEGEMOT_FAST_BUILD_CONFIG_REQUEST_INIT",
    },
    {
        "name": "evlogdump",
        "type": "BEGEMOT_EVLOGDUMP",
    },
)

BUILD_RESOURCES = BUILD_TRUNK_RESOURCES + (
    {
        "name": "bstr",
        "type": "BEGEMOT_BSTR",
    },
    {
        "name": "bstr_caller",
        "type": "BEGEMOT_BSTR_CALLER",
    },
    {
        "name": "eventlog_uploader",
        "type": "BEGEMOT_EVLOG_UPLOADER",
    },
    {
        "name": "fast_build_data_downloader",
        "type": "BEGEMOT_FAST_BUILD_DOWNLOADER",
    },
    {
        "name": "fast_data_callback",
        "type": "BEGEMOT_FAST_DATA_CALLBACK",
    },
    {
        "name": "instancectl.conf",
        "type": "BEGEMOT_INSTANCECTL_CONF",
    },
    {
        "name": "worker.cfg",
        "type": "BEGEMOT_CONFIG",
    },
    {
        "name": "args",
        "type": "BEGEMOT_ARGUMENTS_PARSER",
    },
)

REQUESTS_PLAN_RESOURSE_ID = "1370873029"

PRESTABLE_WEB = [
    "prestable_request_init_web_sas",
]
PROD_WEB = [
    "production_request_init_web_sas",
    "production_request_init_web_man",
    "production_request_init_web_vla",
]
HAMSTER_WEB = [
    "hamster_request_init_web_sas",
    "hamster_request_init_web_man",
    "hamster_request_init_web_vla",
]
WEB_SERVICES = PRESTABLE_WEB + PROD_WEB + HAMSTER_WEB
SHARED_SERVICES = [
    "production_request_init_shared_sas",
    "production_request_init_shared_man",
    "production_request_init_shared_vla"
]
UNIPROXY_SERVICES = [
    "production_request_init_uniproxy_sas",
    "production_request_init_uniproxy_man",
    "production_request_init_uniproxy_vla",
    "hamster_request_init_uniproxy_sas",
    "hamster_request_init_uniproxy_man",
    "hamster_request_init_uniproxy_vla",
]


class BegemotRequestInitCfg(cfg.ReferenceBranchedConfig):
    name = "begemot_request_init"
    display_name = "Begemot RequestInit Shard"
    responsible = "alex-ersh"

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "REPORT_CORE"

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            RESOURCES_TO_RELEASE = [
                jg_job_data.ParentDataDict("component_resources", res['name'], res['type']) for res in BUILD_RESOURCES
            ]

            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrek(),
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(jg_build.JobGraphElementBuildBranched(
                    task_name="RELEASE_BEGEMOT_REQUEST_INIT_RESOURCES",
                    out={res['type']: 90 for res in BUILD_RESOURCES},
                    ctx={
                        "all_resources": False,
                        "begemot_resources": "BegemotConfig RequestInitExecutable Bstr RequestInit NannyConfigs",
                        "build_type": "release",
                        "use_aapi_fuse": True,
                        "definition_flags": "-DRESERVE_ADDRESS_SPACE=128"  # makes sense for HU allocator only
                    },
                ))
                branch_part.append(jg_test.JobGraphElementYappyBetaGeneratorBranched(
                    beta_conf_type="web",
                    job_arrows=jg_job_triggers.JobTriggerBuild(parent_job_data=self.RESOURCES_TO_RELEASE),
                ))
                branch_part.append(jg_test.JobGraphElementLaunchMetrics(
                    search_subtype="web",
                    job_arrows=(
                        jg_job_triggers.JobTriggerGenerateBeta(
                            job_name_parameter="web",
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="checked_beta",
                                    output_key="new_beta_url",
                                ),
                            )
                        )
                    ),
                    ctx={
                        "sample_beta": "hamster",
                        "beta_conf_type": "web",
                        "run_findurl": False,
                        "scraper_over_yt_pool": "report_web_priemka",
                    },
                ))
                branch_part.append(jg_test.JobGraphElementTestTdiAndRearr(
                    job_arrows=(
                        jg_job_triggers.JobTriggerGenerateBeta(
                            job_name_parameter="web",
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="checked_beta",
                                    output_key="new_beta_url",
                                )
                            )
                        )
                    ),
                    job_params={
                        "ctx": {
                            "scraper_over_yt_pool": "report_web_priemka",
                        },
                    }
                ))
                for t in SearchIntergationTestBundle.get_bundle("web", "report_web_priemka"):
                    branch_part.append(t)

                branch_part.append(jg_test.JobGraphElementE2ETest(
                    job_arrows=(
                        jg_job_triggers.JobTriggerGenerateBeta(
                            job_name_parameter="web",
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="hermionee2e_base_url",
                                    output_key="new_beta_url",
                                    transform=lambda x, params: "https://{}.ru".format(x),
                                )
                            )
                        )
                    ),
                ))

                arcadia_tests = [
                    (
                        [
                            "search/begemot/rules/preclassifier_knn/tests/override_thresholds",
                            "web/daemons/flags_raw_provider/tests/shoot_tests",
                            "web/daemons/flags_raw_provider/tests/ut",
                            "web/library/condition_evaluation/ut",
                            "web/library/flags_merge/ut",
                            "web/report/data/flags/tests",
                            "web/src_setup/lib/setup/common/request/ut",
                        ],
                        ["address", "thread", "memory", "leak", "undefined"]
                    ),
                ]
                for targets, sanitizers in arcadia_tests:
                    for sanitize in sanitizers:
                        branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                            task_name="KOSHER_YA_MAKE",
                            job_params={
                                "job_name_parameter": "ARCADIA_TESTS_SANITIZE_" + sanitize.upper(),
                                "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                                "apiargs": {
                                    "kill_timeout": 5 * 3600,
                                }
                            },
                            job_arrows=(
                                jg_arrows.ParamsData(
                                    input_key=sandbox_constants.ARCADIA_URL_KEY,
                                    transform=lambda x, params: "{}/arcadia@{}".format(x.svn_ssh_url, x.revision),
                                ),
                            ),
                            ctx={
                                "targets": ';'.join(targets),
                                "test": True,
                                "disable_test_timeout": True,
                                "sanitize": sanitize,
                            },
                        ))

                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="GET_BEGEMOT_RESPONSES",
                    job_params={
                        "job_name_parameter": "GET_BEGEMOT_RESPONSES_REQUEST_INIT",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    job_arrows=[
                        jg_job_triggers.JobTriggerBuild(parent_job_data=[
                            jg_job_data.ParentDataResource(
                                input_key="begemot_binary",
                                resource_name="BEGEMOT_REQUEST_INIT_EXECUTABLE",
                            ),
                            jg_job_data.ParentDataResource(
                                input_key="fast_build_config",
                                resource_name="BEGEMOT_FAST_BUILD_CONFIG_REQUEST_INIT",
                            )
                        ]),
                    ],
                    out={
                        "BEGEMOT_EVENTLOG": 30,
                    },
                    ctx={
                        "requests_plan": REQUESTS_PLAN_RESOURSE_ID,
                    },
                ))
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="CHECK_BEGEMOT_RESPONSES",
                    job_params={
                        "job_name_parameter": "CHECK_BEGEMOT_RESPONSES_REQUEST_INIT",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    job_arrows=[
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            job_name_parameter="GET_BEGEMOT_RESPONSES_REQUEST_INIT",
                            parent_job_data=[
                                jg_job_data.ParentDataResource(
                                    input_key="begemot_eventlog",
                                    resource_name="BEGEMOT_EVENTLOG",
                                ),
                                jg_job_data.ParentDataCtx(
                                    input_key="queries",
                                    output_key="requests_plan",
                                )
                            ]
                        ),
                        jg_job_triggers.JobTriggerBuild(parent_job_data=[
                            jg_job_data.ParentDataResource(
                                input_key="evlogdump",
                                resource_name="BEGEMOT_EVLOGDUMP",
                            ),
                        ]),
                    ],
                ))
                branch_part.append(jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                    job_arrows=[
                        jg_job_triggers.JobTriggerE2ETest(
                            job_name_parameter="web",
                        ),
                        jg_job_triggers.JobTriggerLaunchMetrics(
                            job_name_parameter="web",
                        ),
                        jg_job_triggers.JobTriggerMetaTest(
                            job_name_parameter="SEARCH_INTEGRATION_TEST",
                        ),
                        jg_job_triggers.JobTriggerMetaTest(
                            job_name_parameter="SEARCH_INTEGRATION_TEST_SOY_HTTP",
                        ),
                        jg_job_triggers.JobTriggerMetaTest(
                            job_name_parameter="SEARCH_INTEGRATION_TEST_STYLE",
                        ),
                        jg_job_triggers.JobTriggerTestTdiAndRearr(),
                    ],
                ))
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_stage = rm_const.ReleaseStatus.stable
                release_part.append(jg_release.JobGraphElementReleaseBranched(
                    release_to=release_stage,
                    job_arrows=[
                        jg_job_triggers.JobTriggerBuild(parent_job_data=self.RESOURCES_TO_RELEASE),
                        jg_job_triggers.JobTriggerNewTag([
                            jg_job_data.ParentDataCtx("major_release_num", "branch_number_for_tag"),
                            jg_job_data.ParentDataCtx("minor_release_num", "new_tag_number"),
                            jg_job_data.ParentDataCtx("release_number", "scope_number", override=True),
                        ]),
                    ],
                ))
                release_part.append(jg_release.JobGraphElementScheduleRelease(
                    release_to=release_stage,
                    job_params={
                        "ctx": {
                            "deploy_system": rm_const.DeploySystem.nanny_push.name,
                            "flows": ["deploy"],
                            "warden_component_name": "request_init",
                            "warden_parent_component_name": "web",
                        }
                    },
                    job_arrows=jg_job_triggers.JobTriggerBuild(parent_job_data=self.RESOURCES_TO_RELEASE)
                ))
                release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                    release_to=release_stage,
                ))
                release_part.append(jg_release.JobGraphElementActionReleaseBase(
                    job_name_parameter="MORTY__{}".format(release_stage),
                    job_params={
                        "should_add_to_db": jg_utils.should_add_to_db_branch,
                        "cancel_fallbehind_runs_on_fix": False,
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerScheduleRelease(),
                        jg_job_triggers.JobTriggerChangelogFinal(),
                    ),
                ))
                return release_part

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "alex-ersh"
            queue = "INITREL"
            summary_template = u"Приемка Begemot RequestInit {}"
            add_commiters_as_followers = True
            deadline = 7

            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }

            use_task_author_as_assignee = False
            write_merges_in_table = True

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = ""
        dirs = [
            "arcadia/search/daemons/begemot/request_init",
            "arcadia/search/begemot/rules/init",
            "arcadia/search/begemot/rules/preclassifier_knn",
            "arcadia/search/wizard/data/wizard/FlagsProvider",
            "arcadia/search/wizard/data/wizard/PreclassifierKnnConfig",
            "arcadia/search/wizard/data/wizard/WizDetectionKnn",
            "arcadia/web/src_setup/lib/setup/common",
            "arcadia/web/daemons/flags_raw_provider/lib",
            "arcadia/web/library/condition_evaluation",
        ]

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        allow_autobranches = False

    class MetricsCfg(cfg.ReferenceBranchedConfig.MetricsCfg):
        limit_s = None

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            deploy_infos = [
                ri.NannyDeployInfo(
                    [
                        ri.DeployService(i, tags=["prod"]) for i in PROD_WEB
                    ] + [
                        ri.DeployService(i, tags=["hamster"]) for i in HAMSTER_WEB
                    ] + [
                        ri.DeployService(i, tags=["prestable"]) for i in PRESTABLE_WEB
                    ] + [
                        ri.DeployService(i, tags=["shared"]) for i in SHARED_SERVICES
                    ] + [
                        ri.DeployService(i, tags=["uniproxy"]) for i in UNIPROXY_SERVICES
                    ]
                )
            ]
            items = [
                ri.ReleasableItem(
                    res['name'],
                    ri.SandboxResourceData(res['type']),
                    deploy_infos=deploy_infos
                ) for res in BUILD_RESOURCES
            ] + [
                ri.DynamicReleasableItem(
                    "scheduled_bundle",
                    ri.SandboxResourceData("SCHEDULED_RM_RELEASE_DATA"),
                    [ri.NannyDeployInfo()],
                )
            ]
            return items

        release_followers_permanent = [
            "alex-ersh",
            "elshiko",
        ]
        wait_for_deploy_time_sec = 4 * 60 * 60
        allow_robots_to_release_stable = True

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "web": yappy_cfg.YappyTemplateCfg(
                template_name="request-init-web",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="request-init-web",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                param_name=res['name'],
                                local_path=res['name'],
                            ) for res in BUILD_RESOURCES
                        ],
                        parent_service="hamster_request_init_web_sas",
                    )
                ])
        }
        working_betas_limit = 2
        wait_for_deploy_time_sec = 4 * 60 * 60

    class ReleaseViewer(cfg.ReferenceBranchedConfig.ReleaseViewer):
        statistics_page_charts = statistics_page.DEFAULT + [statistics_page.PredefinedCharts.TIMESPECTRE_METRICS]
