# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.common.constants import constants as sandbox_constants
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class BellServerCfg(configs.ReferenceCIConfig):
    name = "bell_server"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="ugc"),
        login="stakanviski",
    )

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "entity/ugc/server/modules/bell"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "UGC"
        grant_config_update_permissions_to_release_machine_robot = False

    class JG(basic_build_presets.SingleBuildYaMakeTemplateJGCfg):
        build_task = "projects/ugc/build_bell_server"

        def _get_build_cube(self, graph):
            build = super(self.__class__, self)._get_build_cube(graph)

            build.input.update(**{
                "bell_server_release": True,
                sandbox_constants.CLEAR_BUILD_KEY: True,
            })

            return build

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="bell_server_executable_res_id",
                    data=ri.SandboxResourceData("BELL_SERVER_EXECUTABLE"),
                    deploy_infos=[
                        ri.single_nanny_service("bell_server_sas"),
                    ],
                )
            ]

        release_followers_permanent = [
            "kuznecov",
            "zador",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):
        """Notifications configuration"""

        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = []
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "zador"
            queue = "UGC"
            dev_queue = "UGC"
            summary_template = u"Приемка bell server {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "kuznecov",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "JandeksPoisk/UGC/BellServer/Changelog/"
        dirs = [
            "arcadia/entity/ugc/server/modules/bell",
        ]
        review_groups = [
            "ugc",
        ]

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        start_version = 4  # moved to the CI since the third branch
        branch_name = "ugc/bell_server"
        tag_name = "ugc/bell_server"
