# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class BerthubCfg(configs.ReferenceCIConfig):
    name = "berthub"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="berthub"),
        login="antervis",
    )
    number_last_branches_to_merge = 2

    class CI(configs.ReferenceCIConfig.CI):
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "KWYT"
        a_yaml_dir = "robot/bert"

        ya_make_abs_paths_glob = [
            "robot/bert/**",
            "kernel/bert/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class JG(basic_build_presets.SingleBuildYaPackageInheritorJGCfg):
        build_task = "projects/berthub/build_berthub_package"

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        kpi_alert = 7

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="berthub_package",
                    data=ri.SandboxResourceData("BERTHUB_PACKAGE", ttl=90),
                    deploy_infos=[
                        ri.single_nanny_service("berthub"),
                        ri.single_nanny_service("berthub-test", stage=rm_const.ReleaseStatus.prestable),
                    ],
                ),
            ]

        release_followers_permanent = [
            "antervis",
            "gous32"
            "zosimov",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):

        class Mail(configs.ReferenceCIConfig.Notify.Mail):
            mailing_list = ["kwyt"]

        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = ["kwyt_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "antervis"
            queue = "BERTHUBRELEASE"
            dev_queue = "RTHUBROBOT"
            summary_template = u"Berthub {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "antervis",
                "gous32"
                "zosimov",
            ]
            add_commiters_as_followers = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "robot/berthub/changelogs/"
        dirs = [
            "arcadia/robot/bert",
            "arcadia/kernel/bert",
        ]
        review_groups = [
            "kwyt",
        ]

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        branch_prefix = "pre-stable"
        start_version = 23  # moved to the CI since 22nd branch
