# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class BiathlonCfg(configs.ReferenceBranchedConfig):
    name = "biathlon"
    responsible = "ustas"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_db = "biathlon-trunk2"
        trunk_task_owner = "MR-USERS"
        branch_db_template = "ws-biathlon-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_SEARCH",
                        out={"BIATHLON_PROXY_EXECUTABLE": 40},
                        ctx={
                            "build_sport_proxy": True,
                            "build_type": "release",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="GENERATE_APP_HOST_BENCHMARK_REQUESTS",
                        job_params={
                            "job_name_parameter": "BENCHMARK_GENERATE_REQUESTS",
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(),
                        ),
                        out={
                            "APP_HOST_JSON_CONTEXTS": 30,
                        },
                    )
                )
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="SPORT_PROXY_BENCHMARK_CREATE_ARCHIVE_RESOURCE",
                        job_params={
                            "job_name_parameter": "BENCHMARK_ARCHIVE_PREVIOUS",
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                        },
                        out={
                            "SPORT_PROXY_BENCHMARK_ARCHIVE_RESOURCE": 30,
                        },
                        ctx={
                            "sport_proxy_config": 690479440,
                            "custom_script": 864688759,
                        }
                    )
                )
                for bench_arch_state in ["PREVIOUS", "CURRENT"]:
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="BENCHMARK_APP_HOST_CUSTOM",
                            job_params={
                                "job_name_parameter": "BENCHMARK_{}".format(bench_arch_state),
                                "frequency": (jg_utils.TestFrequency.LAZY, None),
                            },
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="BENCHMARK_ARCHIVE_{}".format(bench_arch_state),
                                    parent_job_data=(
                                        jg_job_data.ParentDataResource(
                                            "any_app_resource",
                                            "SPORT_PROXY_BENCHMARK_ARCHIVE_RESOURCE",
                                        ),
                                    )
                                ),
                                jg_job_triggers.JobTriggerTestBranchCommon(
                                    job_name_parameter="BENCHMARK_GENERATE_REQUESTS",
                                    parent_job_data=(
                                        jg_job_data.ParentDataResource(
                                            "APP_HOST_JSON_CONTEXTS",
                                            "APP_HOST_JSON_CONTEXTS",
                                        )
                                    ),
                                ),
                            ),
                            out={
                                "APP_HOST_BENCHMARK_TESTS": 30,
                            },
                            ctx={
                                "timeout": 180,
                                # hardcoded resources
                                "DPLANNER_EXECUTABLE": 153063466,
                            },
                        )
                    )
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="SPORT_PROXY_BENCHMARK_CREATE_ARCHIVE_RESOURCE",
                        job_params={
                            "job_name_parameter": "BENCHMARK_ARCHIVE_CURRENT",
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        "sport_proxy_binary",
                                        "BIATHLON_PROXY_EXECUTABLE",
                                    ),
                                ),
                            )
                        ),
                        ctx={
                            "sport_proxy_config": 690479440,
                            "custom_script": 864688759,
                        },
                        out={
                            "SPORT_PROXY_BENCHMARK_ARCHIVE_RESOURCE": 30,
                        },
                    )
                )
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BENCHMARK_APP_HOST_DIFF2",
                        job_params={
                            "job_name_parameter": "BENCHMARK_DIFF",
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="BENCHMARK_CURRENT",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        "last_tests",
                                        "APP_HOST_BENCHMARK_TESTS",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="BENCHMARK_PREVIOUS",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        "previous_tests",
                                        "APP_HOST_BENCHMARK_TESTS",
                                    ),
                                ),
                            ),
                        ),
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "biathlon",
                                        "BIATHLON_PROXY_EXECUTABLE",
                                    )
                                )
                            )
                        )
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            @property
            def change_frequency(self):
                uppercase_name = self.name.upper()
                return {
                    "_LOG_MERGE__{}".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_{}_UMBRELLA_ACCEPT_BY_MARKER".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_{}_UMBRELLA_ACCEPT_SCHEDULED".format(uppercase_name): rm_const.TestFrequencies.ONCE_A_DAY_TEST,
                    "_BUILD_RELEASE_{}".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_BUILD_RELEASE_{}SEARCH".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_NEW_TAG__{}".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                }

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="biathlon",
                    data=ri.SandboxResourceData("BIATHLON_PROXY_EXECUTABLE"),
                    deploy_infos=[ri.single_nanny_service("parallel-biathlon-yp")]
                ),
            ]

        release_followers_permanent = [
            "nkmakarov",
            "panoff",
            "ustas",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "ustas"
            queue = "SPORTSERP"
            dev_queue = "SPORTSERP"
            summary_template = u"Приемка BIATHLON {}"
            workflow = {}
            followers = [
                "nkmakarov",
                "ustas",
                "panoff",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "jandekspoisk/kachestvopoiska/svezhestvydachi/sportproxyreleases/"
        dirs = [
            "arcadia/extsearch/wizards/sport_proxy/",
        ]
