# -*- coding: utf-8 -*-

from sandbox.projects.common import constants as sandbox_constants

from sandbox.projects.release_machine.components.configs.bigb import _constants as bigb_constants

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.job_graph.presets import ci_presets
from sandbox.projects.release_machine.components.job_graph import utils as jg_utils

from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


class BigbEagleCICfg(configs.ReferenceCIConfig):
    name = "bigb_eagle_ci"
    display_name = "BIGB Eagle (CI)"
    responsible = bigb_constants.RESPONSIBLE

    class MergesCfg(configs.ReferenceCIConfig.MergesCfg):
        number_last_branches_to_merge = 1

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "ads/bsyeti"
        secret = bigb_constants.SECRET_ID
        sb_owner_group = bigb_constants.TRUNK_TASK_OWNER
        grant_config_update_permissions_to_release_machine_robot = False

        class JobGraph(configs.ReferenceCIConfig.CI.JobGraph):
            _preset = ci_presets.SingleBuildPackageCiPreset(
                resource_names="EAGLE_SAMOGON_PACKAGE",
                package_names="ads/bsyeti/samogon/eagle/package.json",
                build_task_name="YA_PACKAGE_2",
                build_apiargs={
                    "kill_timeout": 2700,
                },
                build_ctx={
                    sandbox_constants.BUILD_TYPE_KEY: sandbox_constants.RELEASE_WITH_DEBUG_INFO_BUILD_TYPE,
                    sandbox_constants.USE_AAPI_FUSE: True,
                    sandbox_constants.ALLOW_AAPI_FALLBACK: True,
                    "resource_type": "EAGLE_SAMOGON_PACKAGE",
                    "packages": "ads/bsyeti/samogon/eagle/package.json",
                    "compress_package_archive": True,
                    "package_type": "tarball",
                    "use_new_format": True,
                    "ya_yt_store": True,
                    "custom_version": "release-r${context.target_revision.number}-"
                                      "${context.version_info.major}.${not_null(context.version_info.minor, `0`)}",
                },
                deploy_system=rm_const.DeploySystem.ya_deploy.name,
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.testing, jg_utils.Lazy()),
                ],
            )

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="EAGLE_SAMOGON_PACKAGE",
                    data=ri.SandboxResourceData("EAGLE_SAMOGON_PACKAGE", ttl=30),
                    deploy_infos=[
                        ri.SamogonDeployInfo(ri.DeployService("eagle12"), rm_const.ReleaseStatus.testing),
                    ]
                )
            ]

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            queue = "BIGBRELEASE"
            summary_template = "BIGB Eagle Release {}"
            assignee = bigb_constants.RESPONSIBLE
            workflow = {}
            add_commiters_as_followers = False

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        branch_name = "bigb/eagle"
        tag_name = "bigb/eagle"

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        observed_paths = ["arcadia/ads/bsyeti/eagle", "arcadia/ads/bsyeti/samogon/eagle"]
        wiki_page = "bigb/releases/changelog/eagle"
