# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.common.constants import constants as common_const
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test


class BigbBalancerCfg(configs.ReferenceBranchedConfig):
    name = "bigb_balancer"
    responsible = "pechatnov"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "bigb_balancer"
        trunk_task_owner = "BSYETI"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildPackageBranched(
                        task_name="BUILD_BIGB_PACKAGE",
                        job_params={
                            "apiargs": {"requirements": {"disk_space": 50 * (1024 ** 3)}},
                        },
                        use_compression=False,
                        resource_names="BIGB_BALANCER_SAMOGON_PACKAGE",
                        package_names="ads/bsyeti/samogon/balancer/package.json",
                        ctx={
                            common_const.CHECKOUT_MODE: common_const.CHECKOUT_MODE_AUTO,
                            common_const.CHECKOUT: True,
                        },
                        out={
                            "BIGB_BALANCER_SAMOGON_PACKAGE": 30,
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTrunkWaiter()
                )
                return branch_part

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        """Release viewer configuration"""
        kpi_alert = 7

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        samogon_contour_to_check = "bigbbalancer3"
        resources_info = [
            configs.ReleasedResourceInfo(
                name="bigb_balancer_samogon_package_res_id",
                resource_type="BIGB_BALANCER_SAMOGON_PACKAGE",
            ),
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "bigb/balancer"
        use_arc = True

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            """Mail notifications configuration"""
            mailing_list = [
                "bsyeti-watcher@yandex-team.ru",
            ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            config = configs.RmTelegramNotifyConfig(chats=["bigb_balancer_comp"])

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "pechatnov"
            queue = "BIGBRELEASE"
            dev_queue = "BIGB"
            summary_template = "New BIGB BALANCER v{}"
            workflow = {}
            followers = [
                "cberg",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = True
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "bigb/balancer/changelog"
        dirs = [
            "arcadia/ads/bsyeti/samogon/balancer",
        ]
