# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class BigbOracleCfg(configs.ReferenceBranchedConfig):
    name = "bigb_oracle"
    responsible = "pechatnov"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "bigb_oracle"
        trunk_task_owner = "BSYETI"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildPackageBranched(
                        task_name="BUILD_BIGB_PACKAGE",
                        resource_names="BIGB_ORACLE_SAMOGON_PACKAGE",
                        package_names="ads/bsyeti/samogon/bigb_oracle/package.json",
                        use_compression=False,
                        job_params={
                            "job_name_parameter": "SAMOGON_PACKAGE",
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 50 * 1024 ** 3,  # 50 Gb
                                }
                            },
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(),
                        ),
                        out={
                            "BIGB_ORACLE_SAMOGON_PACKAGE": 30
                        },
                    )
                )
                return branch_part

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        """Release viewer configuration"""
        kpi_alert = 7

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        samogon_contour_to_check = "oracle"
        resources_info = [
            configs.ReleasedResourceInfo(
                name="oracle_samogon_package_res_id",
                resource_type="BIGB_ORACLE_SAMOGON_PACKAGE",
            ),
        ]
        allow_robots_to_release_stable = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "bigb/oracle"
        use_arc = True

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            """Mail notifications configuration"""
            mailing_list = [
                "bsyeti-watcher@yandex-team.ru",
            ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            config = configs.RmTelegramNotifyConfig(chats=["bigb_oracle_comp"])

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "pechatnov"
            queue = "BIGBRELEASE"
            dev_queue = "BIGB"
            summary_template = "New BIGB ORACLE v{}"
            workflow = {}
            followers = [
                "amitin",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = True
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "bigb/oracle/changelog"
        dirs = [
            "arcadia/ads/bsyeti",
        ]
