# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test


class BigbResharderCfg(configs.ReferenceBranchedConfig):
    name = "bigb_resharder"
    responsible = "pechatnov"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "bigb_resharder"
        trunk_task_owner = "BSYETI"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildPackageBranched(
                        task_name="BUILD_BIGB_PACKAGE",
                        resource_names="RESHARDER_SAMOGON_PACKAGE",
                        package_names="ads/bsyeti/samogon/resharder/package.json",
                        use_compression=False,
                        job_params={
                            "job_name_parameter": "SAMOGON_PACKAGE",
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 10 * 1024 ** 3,  # 10 Gb
                                }
                            }
                        },
                        out={
                            "RESHARDER_SAMOGON_PACKAGE": 30,
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTrunkWaiter()
                )
                return branch_part

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        """Release viewer configuration"""
        kpi_alert = 7

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        samogon_contour_to_check = "resharder3"
        resources_info = [
            configs.ReleasedResourceInfo(
                name="resharder_samogon_package_res_id",
                resource_type="RESHARDER_SAMOGON_PACKAGE",
            ),
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "bigb/resharder"
        use_arc = True

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            """Mail notifications configuration"""
            mailing_list = [
                "bsyeti-watcher@yandex-team.ru",
            ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            config = configs.RmTelegramNotifyConfig(chats=["bigb_resharder_comp"])

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "pechatnov"
            queue = "BIGBRELEASE"
            dev_queue = "BIGB"
            summary_template = "New BIGB RESHARDER v{}"
            workflow = {}
            followers = [
                "amitin",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = True
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "bigb/resharder/changelog"
        dirs = [
            "arcadia/ads/bsyeti",
        ]
