# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.common.constants import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


RESOURCES = [
    "NLGSEARCH_BINARY",
    "NLGSEARCH_SHARD",
    "NLGSEARCH_CONFIG",
]

RESPONSIBLE = configs.Responsible(
    abc=configs.Abc(service_name="conversation", component_id=2738),
    login="nzinov",
)


class BoltalkaCfg(configs.ReferenceBranchedConfig):
    """Boltalka is an Alice component, also known as General Conversation"""
    name = "boltalka"
    responsible = RESPONSIBLE

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "VINS"
        branch_task_owner = "BASS"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            build_release_job_data = [
                jg_job_data.ParentDataDict("component_resources", i.lower(), i)
                for i in RESOURCES
            ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                for build_stage in [sandbox_constants.RELEASE_BUILD_TYPE]:
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="BUILD_BOLTALKA",
                            job_params={
                                "job_name_parameter": build_stage,
                                "apiargs": {
                                    "requirements": {
                                        "disk_space": 40960,
                                    }
                                }
                            },
                            job_arrows=(
                                jg_arrows.ParamsData(
                                    input_key="rev",
                                    transform=lambda x, rm_config: x.revision,
                                ),
                            ),
                            ctx={
                                "release_type": "production",
                            },
                            out={i: 90 for i in RESOURCES},
                        )
                    )
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="beta",
                        ctx={"beta_name_source": "STRING"},
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="patch_name",
                                transform=lambda x, rm_config: "branch-{}".format(jg_utils.get_major_release_number(x, rm_config)),
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter=sandbox_constants.RELEASE_BUILD_TYPE,
                                parent_job_data=self.build_release_job_data,
                            ),
                        )
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="RUN_NIRVANA_WORKFLOW",
                        job_params={
                            "job_name_parameter": "run_acceptance"
                        },
                        job_arrows=(
                            jg_arrows.ParentsData(
                                input_key="nirvana_global_options",
                                triggers=(
                                    jg_job_triggers.JobTriggerGenerateBeta(
                                        job_name_parameter="beta",
                                        parent_job_data=(
                                            jg_job_data.ParentDataCtx(
                                                input_key="beta_hostname",
                                                output_key="beta_name",
                                                transform=lambda x, params: "{}.yappy.beta.yandex.ru".format(x),
                                            ),
                                        ),
                                    ),
                                    jg_job_triggers.JobTriggerNewTag(
                                        parent_job_data=(
                                            jg_job_data.ParentDataCtx(
                                                input_key="tag",
                                                output_key="tag_name",
                                            )
                                        ),
                                    )
                                ),
                                transform=lambda beta_hostname, tag: dict(host=beta_hostname, name="{}-auto-acceptance".format(tag))
                            )
                        ),
                        ctx={
                            "nirvana_workflow_id": "3bb9774c-fc2c-4e56-9dd9-47b406302f98",
                            "nirvana_token": "VINS:boltalka-nirvana-token",
                            "nirvana_project_id": "nzinov-fml",
                            "nirvana_quota": "dialogs",
                            "nirvana_workflow_name": "Boltalka acceptance"
                        }
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranched(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(job_name_parameter="run_acceptance"),
                        ),
                        frequency=(jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 42),
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter=sandbox_constants.RELEASE_BUILD_TYPE,
                                parent_job_data=self.build_release_job_data,
                            )
                        )
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            deploy_infos = [ri.NannyDeployInfo(
                [ri.DeployService("general-conversation-ru-yp-{}".format(loc)) for loc in rm_const.MAIN_LOCATIONS]
            )]
            return [
                ri.ReleasableItem(
                    name=i.lower(),
                    data=ri.SandboxResourceData(i),
                    deploy_infos=deploy_infos
                ) for i in RESOURCES
            ]
        wait_for_deploy_time_sec = 3600
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = [
                "boltalka-releases@yandex-team.ru",
            ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["bass_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = "https://t.me/joinchat/AAAAAEUzgJcHCRaSP_o0cw"

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = RESPONSIBLE
            queue = "ALICERELEASE"
            dev_queue = "ALICE"
            summary_template = u"Релиз Болталки {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "alipov",
                "nzinov",
            ]
            add_commiters_as_followers = True
            deadline = 2
            hide_commits_under_cut = True
            important_changes_limit = 100
            notify_on_deploy_to_feature_st_tickets = True

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = ""
        observed_paths = [
            "arcadia/alice/boltalka/extsearch",
            "arcadia/alice/boltalka/libs",
        ]
        review_groups = []

    class Yappy(yappy_cfg.YappyBaseCfg):
        """ Config to generate yappy betas """
        betas = {
            "beta": yappy_cfg.YappyTemplateCfg(
                template_name="alice-general-conversation-rm",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="alice-general-conversation-rm",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                param_name="nlgsearch_binary",
                                local_path="nlgsearch",
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                param_name="nlgsearch_shard",
                                local_path="shard",
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                param_name="nlgsearch_config",
                                local_path="search.cfg",
                            ),
                        ],
                        parent_service="general-conversation-ru-yp-sas",
                    )
                ])
        }
        working_betas_limit = 2
