# -*- coding: utf-8 -*-
import re

import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.core.releasable_items as ri
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class CbirdaemonCfg(configs.ReferenceBranchedConfig):
    name = "cbirdaemon"
    display_name = u"Cbirdaemon"
    responsible = "woxalex"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "CV-TESTENV"
        branch_task_owner = "CV-TESTENV-RELEASE"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrek()
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="IMAGES_BUILD_SEARCH_BINARY",
                        job_params={
                            "job_name_parameter": "NOLTO",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        ctx={
                            "build_cbirdaemon2": True
                        },
                        out={
                            "CBIR_DAEMON2_EXECUTABLE": 90,
                            "CBIR_DAEMON2_API_CONFIG": 90
                        },
                    )
                )
                for job_name_param in ["gpu", "omp"]:
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="IMAGES_BUILD_SEARCH_BINARY",
                            job_params={
                                "job_name_parameter": job_name_param.upper(),
                                "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            },
                            ctx={
                                "build_extra_cbirdaemon2_{}".format(job_name_param): True,
                            },
                            out={
                                "CBIR_DAEMON2_{}_EXECUTABLE".format(job_name_param.upper()): 90,
                                "CBIR_DAEMON2_{}_CONFIG".format(job_name_param.upper()): 90
                            },
                        )
                    )
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="beta",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="GPU",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "cbir_daemon2_gpu_binary",
                                        "CBIR_DAEMON2_GPU_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "cbir_daemon2_gpu_config",
                                        "CBIR_DAEMON2_GPU_CONFIG",
                                    ),
                                )
                            )
                        ),
                        ctx={
                            "beta_name_source": "STRING",
                            "patch_name": "acceptance",
                            "force_start_beta": True,
                        },
                    )
                )
                METRICS_SLA_PROJECT = "aa8286386850f0df016874cc48882d44"  # Metrics SLA-project "SLA Release Machine", more info at https://metrics.yandex-team.ru/admin/sla
                branch_part.append(
                    jg_test.JobGraphElementLaunchMetrics(
                        search_subtype="images",
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="checked_beta",
                                        output_key="beta_name",
                                        transform=lambda x, params: "{}.hamster".format(x),
                                    )
                                )
                            )
                        ),
                        ctx={
                            "custom_template_name": "cbir.json",
                            "sample_beta": "hamster",
                            "scraper_over_yt_pool": "hamster_search_by_image",
                            "sla_project": METRICS_SLA_PROJECT,
                        }
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedScheduled(
                        job_arrows=(
                            jg_job_triggers.JobTriggerLaunchMetrics(
                                job_name_parameter="images"
                            ),
                        ),
                        frequency=(jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTrunkWaiter()
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="NOLTO",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "cbir_daemon2_binary",
                                        "CBIR_DAEMON2_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "cbir_daemon2_config",
                                        "CBIR_DAEMON2_API_CONFIG",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="GPU",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "cbir_daemon2_gpu_binary",
                                        "CBIR_DAEMON2_GPU_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "cbir_daemon2_gpu_config",
                                        "CBIR_DAEMON2_GPU_CONFIG",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="OMP",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "cbir_daemon2_omp_binary",
                                        "CBIR_DAEMON2_OMP_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "cbir_daemon2_omp_config",
                                        "CBIR_DAEMON2_OMP_CONFIG",
                                    ),
                                ),
                            ),
                        )
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            cbir_daemon_services = [
                ri.NannyDeployInfo(
                    [
                        ri.DeployService("production-{}-imgcbrd-ext-yp".format(loc), tags=["prod"])
                        for loc in rm_const.MAIN_LOCATIONS
                    ] + [
                        ri.DeployService("hamster-sas-imgcbrd-ext-yp", tags=["hamster"])
                    ]
                ),
            ]
            cbir_daemon_gpu_services = [
                ri.NannyDeployInfo([
                    ri.DeployService("production-sas-imgcbrd-gpu-yp", tags=["prod"]),
                    ri.DeployService("production-vla-imgcbrd-gpu-yp", tags=["prod"]),
                ])
            ]
            cbir_daemon_omp_services = [
                ri.NannyDeployInfo(
                    [
                        ri.DeployService("production-{}-imgcbrd-yp".format(loc), tags=["prod"])
                        for loc in rm_const.MAIN_LOCATIONS
                    ] + [
                        ri.DeployService("hamster-man-imgcbrd-yp", tags=["hamster"]),
                        ri.DeployService("hamster-sas-imgcbrd-yp", tags=["hamster"])
                    ]
                ),
            ]
            return [
                ri.ReleasableItem(
                    name="cbir_daemon2_binary",
                    data=ri.SandboxResourceData("CBIR_DAEMON2_EXECUTABLE"),
                    deploy_infos=cbir_daemon_services,
                ),
                ri.ReleasableItem(
                    name="cbir_daemon2_config",
                    data=ri.SandboxResourceData("CBIR_DAEMON2_API_CONFIG"),
                    deploy_infos=cbir_daemon_services,
                ),
                ri.ReleasableItem(
                    name="cbir_daemon2_gpu_binary",
                    data=ri.SandboxResourceData("CBIR_DAEMON2_GPU_EXECUTABLE"),
                    deploy_infos=cbir_daemon_gpu_services,
                ),
                ri.ReleasableItem(
                    name="cbir_daemon2_gpu_config",
                    data=ri.SandboxResourceData("CBIR_DAEMON2_GPU_CONFIG"),
                    deploy_infos=cbir_daemon_gpu_services,
                ),
                ri.ReleasableItem(
                    name="cbir_daemon2_omp_binary",
                    data=ri.SandboxResourceData("CBIR_DAEMON2_OMP_EXECUTABLE"),
                    deploy_infos=cbir_daemon_omp_services,
                ),
                ri.ReleasableItem(
                    name="cbir_daemon2_omp_config",
                    data=ri.SandboxResourceData("CBIR_DAEMON2_OMP_CONFIG"),
                    deploy_infos=cbir_daemon_omp_services,
                ),
            ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["cvduty"]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = u"https://t.me/joinchat/DCBSykgRgqKO9dUjuIl-fQ"

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "woxalex"
            queue = "CV"
            dev_queue = "CV"
            summary_template = u"Приемка cbirdaemon {}"
            followers = [
                "woxalex",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7
            nanny_reports = False
            commit_importance_threshold = 4
            close_prev_tickets_stage = rm_const.PipelineStage.deploy
            banned_queues = {
                "IGNIETFERRO",
                "MLTOOLS",
            }
            workflow = {
            }

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = ""
        dirs = []
        markers = [
            (4, re.compile(r"\bdiff *: *(cbirdaemon)", flags=re.IGNORECASE)),
            (4, re.compile(r"(\[cbirdaemon\])", flags=re.IGNORECASE)),
            (4, re.compile(r"(\[CD\])", flags=re.IGNORECASE)),
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "images/cbirdaemon"
        tag_name = "images/cbirdaemon"
        max_active_branches = 2
        allow_autobranches = False

    class MetricsCfg(configs.ReferenceBranchedConfig.MetricsCfg):
        """Metrics configuration"""
        limit_s = None

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "beta": yappy_cfg.YappyBetaCfg(
                beta_name="cbirdaemon-priemka-test",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyBetaPatch(
                        patch_file="cbirdaemon-gpu",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="cbirdaemon2",
                                param_name="cbir_daemon2_gpu_binary"
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="cbirdaemon.conf",
                                param_name="cbir_daemon2_gpu_config"
                            ),
                            yappy_cfg.YappyLastReleasedResource(
                                local_path="cbirdaemon_data",
                                res_type="CBIR_DAEMON2_GPU_SETTINGS"
                            ),
                        ],
                        parent_service="priemka-vla-imgcbrd-gpu",
                        ignore_instance_spec=True,
                    ),
                ],
            )
        }
