# -*- coding: utf-8 -*-
import re

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class CbirdaemonDataCfg(configs.ReferenceTaggedConfig):
    name = "cbirdaemon_data"
    display_name = u"Cbirdaemon data"
    responsible = "woxalex"

    class Releases(configs.ReferenceTaggedConfig.Releases):
        allow_old_releases = True

        @property
        def releasable_items(self):
            cbir_daemon_services = [
                ri.NannyDeployInfo(
                    [
                        ri.DeployService("production-{}-imgcbrd-ext-yp".format(loc), tags=["prod"])
                        for loc in rm_const.MAIN_LOCATIONS
                    ] + [
                        ri.DeployService("hamster-sas-imgcbrd-ext-yp", tags=["hamster"])
                    ]
                ),
            ]
            cbir_daemon_gpu_services = [
                ri.NannyDeployInfo([
                    ri.DeployService("production-sas-imgcbrd-gpu-yp", tags=["prod"]),
                    ri.DeployService("production-vla-imgcbrd-gpu-yp", tags=["prod"]),
                ])
            ]
            cbir_daemon_omp_services = [
                ri.NannyDeployInfo(
                    [
                        ri.DeployService("production-{}-imgcbrd-yp".format(loc), tags=["prod"])
                        for loc in rm_const.MAIN_LOCATIONS
                    ] + [
                        ri.DeployService("hamster-man-imgcbrd-yp", tags=["hamster"]),
                        ri.DeployService("hamster-sas-imgcbrd-yp", tags=["hamster"])
                    ]
                ),
            ]
            return [
                ri.ReleasableItem(
                    name="cbir_daemon2_settings",
                    data=ri.SandboxResourceData("CBIR_DAEMON2_SETTINGS"),
                    deploy_infos=cbir_daemon_omp_services,
                ),
                ri.ReleasableItem(
                    name="cbir_daemon2_gpu_settings",
                    data=ri.SandboxResourceData("CBIR_DAEMON2_GPU_SETTINGS"),
                    deploy_infos=cbir_daemon_gpu_services,
                ),
                ri.ReleasableItem(
                    name="cbir_daemon2_api_settings",
                    data=ri.SandboxResourceData("CBIR_DAEMON2_API_SETTINGS"),
                    deploy_infos=cbir_daemon_services,
                ),
            ]

    class Testenv(configs.ReferenceTaggedConfig.Testenv):
        trunk_task_owner = "CV-RELEASERS"
        trunk_db = "images-cbirdaemon-data-trunk"

        class JobGraph(configs.ReferenceTaggedConfig.Testenv.JobGraph):
            @property
            def _tag_part(self):
                tag_part = super(self.__class__, self)._tag_part
                tag_part.append(
                    jg_build.JobGraphElementBuildTagged(
                        task_name="IMAGES_BUILD_CBIRDAEMON_2_DATABASE",
                        out={
                            "CBIR_DAEMON2_SETTINGS": 90,
                            "CBIR_DAEMON2_GPU_SETTINGS": 90,
                            "CBIR_DAEMON2_API_SETTINGS": 90
                        }
                    )
                )
                return tag_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(jg_release.JobGraphElementNewTagTagged())
                release_part.append(jg_prerelease.JobGraphElementPreliminaryChangelogTagged())
                release_part.append(
                    jg_release.JobGraphElementReleaseTagged(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "cbir_daemon2_settings",
                                        "CBIR_DAEMON2_SETTINGS",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "cbir_daemon2_gpu_settings",
                                        "CBIR_DAEMON2_GPU_SETTINGS",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "cbir_daemon2_api_settings",
                                        "CBIR_DAEMON2_API_SETTINGS",
                                    ),
                                ),
                            ),
                        )
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseTagged(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

    class Notify(configs.ReferenceTaggedConfig.Notify):
        use_startrek = False

        class Telegram(configs.ReferenceTaggedConfig.Notify.Telegram):
            chats = ["cvduty"]

    class ChangelogCfg(configs.ReferenceTaggedConfig.ChangelogCfg):
        wiki_page = ""
        observed_paths = []
        markers = [
            (4, re.compile(r"\bdiff *: *(cbirdaemon data)", flags=re.IGNORECASE)),
            (4, re.compile(r"(\[cbirdaemon data\])", flags=re.IGNORECASE)),
            (4, re.compile(r"(\[CD DATA\])", flags=re.IGNORECASE)),
        ]

    class SvnCfg(configs.ReferenceTaggedConfig.SvnCfg):
        tag_name = "cbirdaemon_data"

    def __init__(self):
        super(CbirdaemonDataCfg, self).__init__()
        self.changelog_cfg = self.ChangelogCfg(self, self.svn_cfg.main_url, self.responsible)
