from sandbox.projects.dj.services.chz.specs import specs
from sandbox.projects.dj.services.chz.specs import utils

from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube_base


def make_chz_recommender_pair_perf_cube(test_stand_resources, **input_kwargs):
    input_kwargs.setdefault('test_stand_resources', {}).update(test_stand_resources)
    input_kwargs.setdefault('select_plan', True)

    return jg_cube.Cube(
        task='projects/chz/chz_pair_perf_test',
        input=jg_cube.CubeInput(**input_kwargs),
    )


def make_accept_release_cubes(build_stage_cube, test_stage_cubes, release_stage_cube):
    accept_results_cube = jg_cube.Cube(
        task="dummy",
        title="Accept Results",
        needs=test_stage_cubes,
    )
    skip_accept_results_cube = jg_cube.Cube(
        task="dummy",
        title="Skip/Confirm Results Accepting",
        needs=[build_stage_cube],
        manual=True,
    )
    allow_release_cube = jg_cube.Cube(
        task="dummy",
        title="Allow Release",
        needs=[skip_accept_results_cube, accept_results_cube],
        needs_type=jg_cube_base.CubeNeedsType.ANY,
    )
    release_stage_cube.add_requirement(allow_release_cube)

    return accept_results_cube, skip_accept_results_cube, allow_release_cube


def make_chz_release_notify_cube(spec_resource_type, **input_kwargs):
    input_kwargs['release_resource'] = spec_resource_type
    input_kwargs.setdefault('ci_job_url', '${context.ci_job_url}')

    return jg_cube.Cube(
        task='projects/chz/chz_release_notifier',
        input=jg_cube.CubeInput(**input_kwargs),
    )


def make_build_cube_dep_for_resource(build_cube, spec_resource_name):
    resource_id_selector = make_resource_id_selector(build_cube, spec_resource_name)
    return {
        spec_resource_name: resource_id_selector
    }


def make_resource_id_selector(build_cube, spec_resource_name):
    resource_type = utils.lookup_resource_type_in_metadata(
        spec_type=specs.ChzRecommenderSpec,
        spec_resource_name=spec_resource_name
    )
    return build_cube.output.resources[resource_type].first().id
