
from sandbox.projects.release_machine.core import const as rm_const


def recommender_services_with_release_types():
    return (
        ("recommender_server_prestable", rm_const.ReleaseStatus.testing),
        ("recommender_server_prod", rm_const.ReleaseStatus.stable),
    )


def recommender_deploy_service_static_resource_patch_stub(resource_name, deploy_unit='deploy_unit'):
    static_resource_kwargs = dict(
        deploy_unit_id=deploy_unit,
        static_resource_ref=resource_name,
    )

    return _make_static_resource_patch_stub(static_resource_kwargs)


def recommender_deploy_service_static_layer_patch_stub(layer_id, deploy_unit='deploy_unit'):
    static_resource_kwargs = dict(
        deploy_unit_id=deploy_unit,
        layer_ref=layer_id,
    )

    return _make_static_resource_patch_stub(static_resource_kwargs)


def _make_static_resource_patch_stub(static_resource_kwargs):
    from yp_proto.yp.client.api.proto import deploy_patch_pb2

    return deploy_patch_pb2.TDeployPatchSpec(
        sandbox=deploy_patch_pb2.TSandboxResourceDeployPatch(
            sandbox_resource_type=None,  # to be filled later
            static=deploy_patch_pb2.TStaticResourceRef(**static_resource_kwargs)
        )
    )


def make_release_config_from_patch_stub_and_resource(sandbox_resource_data, service):
    from google.protobuf import json_format
    from infra.deploy_ci.create_release.proto import create_release_pb2
    from yp_proto.yp.client.api.proto import deploy_patch_pb2

    result_patches = []

    for patch in service._patch_configuration:
        result_patch = deploy_patch_pb2.TDeployPatchSpec()
        result_patch.CopyFrom(patch)
        result_patch.sandbox.sandbox_resource_type = sandbox_resource_data.resource_type
        result_patches.append(result_patch)

    pb_config = create_release_pb2.Input.Config(stage_id=service._stage_id, patches=result_patches)
    return json_format.MessageToDict(pb_config, preserving_proto_field_name=True)
