from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import deploy as deploy_release_cubes

from sandbox.projects.release_machine.components.configs.chz.deploy_to_deploy import releasable_items as deploy_releasable_items
from sandbox.projects.release_machine.components.configs.chz import deploy_chz_details


class JGDeployReleaseSupportedCfgMixin(object):
    def _make_release_deploy_cube(self, deploy_system, where, releasable_item, service, build):
        return deploy_release_cubes.CreateDeployRelease(
            name="release_{}_{}_{}".format(where, deploy_system, service._stage_id),
            manual=True,
            component_name=self.component_name,
            where_to_release=where,
            input=jg_cube.CubeInput(
                config=deploy_chz_details.make_release_config_from_patch_stub_and_resource(
                    sandbox_resource_data=releasable_item.data,
                    service=service,
                )
            ),
            needs=[build],
        )

    def _get_release_cubes_for_deploy_system(self, deploy_system, where, releasable_items, graph, build):
        result = []

        ris_with_services = [
            (releasable_item, service)

            for releasable_item in releasable_items
            for deploy_info in releasable_item.deploy_infos
            for service in deploy_info.services

            if deploy_info.deploy_system.name == deploy_system and deploy_info.stage == where
        ]

        ris_with_no_services = [
            releasable_item

            for releasable_item in releasable_items
            for deploy_info in releasable_item.deploy_infos

            if deploy_info.deploy_system.name == deploy_system and deploy_info.stage == where and not deploy_info.services
        ]

        services_with_deploy_task_release = [
            service
            for _, service in ris_with_services
            if isinstance(service, deploy_releasable_items.DeployServiceWithResourcePatch)

        ]

        if services_with_deploy_task_release:
            result.extend(
                self._make_release_deploy_cube(deploy_system, where, releasable_item, service, build)
                for (releasable_item, service) in ris_with_services
            )

        if len(services_with_deploy_task_release) < len(ris_with_services) or ris_with_no_services:
            base_class_release_cubes = super(JGDeployReleaseSupportedCfgMixin, self)._get_release_cubes_for_deploy_system(
                deploy_system,
                where,
                releasable_items,
                graph,
                build
            )
            result.extend(base_class_release_cubes)

        return result
