# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core import responsibility
from sandbox.projects.release_machine.components.config_core.bases import ci
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.graph import base as graph_base
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.configs.chz import _common as chz_rm_common
from sandbox.projects.release_machine.components.configs.chz import deploy_chz_details
from sandbox.projects.release_machine.components.configs.chz.deploy_to_deploy import releasable_items as deploy_releasable_items
from sandbox.projects.release_machine.components.configs.chz.deploy_to_deploy import basic_build_presets as local_basic_build_presets


class ChzRecommenderCfg(ci.ReferenceCIConfig):
    name = "chz_recommender"
    responsible = responsibility.Responsible(
        abc=responsibility.Abc(
            service_name="chz",
            schedule_slug="base_duty",
        ),
        login="phil-grab",
    )

    class JG(local_basic_build_presets.JGDeployReleaseSupportedCfgMixin, basic_build_presets.SingleBuildYaPackageJGCfg):
        @staticmethod
        def make_perf_test_cube_from_build_package_task(build):
            return chz_rm_common.make_chz_recommender_pair_perf_cube(
                test_stand_resources=chz_rm_common.make_build_cube_dep_for_resource(
                    build_cube=build,
                    spec_resource_name="bundle"
                )
            )

        @jg_flow.release_flow(
            title="Chz Recommender bundle release",
            description="A normal release with all tests",
        )
        def release(self):
            graph = super(self.__class__, self).release(self)

            build = graph.get("build_ya_package_2")
            perf_test = self.make_perf_test_cube_from_build_package_task(build)
            graph.add(perf_test)

            release = graph.get("release_stage_entry")

            accept_release_cubes = chz_rm_common.make_accept_release_cubes(
                build_stage_cube=build,
                test_stage_cubes=[perf_test],
                release_stage_cube=release,
            )

            for cube in accept_release_cubes:
                graph.add(cube)

            release.add_requirement(accept_release_cubes[-1])

            return graph

        @jg_flow.register_flow(
            title="PR shoots test for chz recommender bundle",
            description="Building and running shooting tests in sandbox. Does all the job on manual confirmation for the first dummy cube",
            triggers=[jg_flow.ActionTrigger(on=jg_flow.ActionTriggerOn.PR, into="trunk", required=False)],
        )
        def pr_test(self):
            dummy = dummy_cubes.RMMainGraphEntry(manual=True)
            graph = graph_base.Graph([dummy])

            build = self._get_build_cube(graph)
            graph.add(build)

            perf_test = self.make_perf_test_cube_from_build_package_task(build)
            graph.add(perf_test)

            return graph

    class CI(ci.ReferenceCIConfig.CI):
        a_yaml_dir = "dj/services/chz"
        secret = "sec-01f1pse0y7chjt929599g72qk2"
        sb_owner_group = "CHZ"

        # включаем graph- и dir-discovery по этим путям
        ya_make_abs_paths_glob = [
            "dj/services/chz/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(ci.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="chz_recommender_package",
                    data=ri.SandboxResourceData("CHZ_DJ_RECOMMENDER_PACKAGE"),
                    build_data=ri.BuildData(
                        target="dj/services/chz/recommender_server/package.json",
                    ),
                    deploy_infos=[
                        # ri.YaDeployInfo(
                        #     ri.DeployService("recommender_server_prestable"),
                        #     stage=rm_const.ReleaseStatus.testing
                        # ),
                        # ri.YaDeployInfo(
                        #     ri.DeployService("recommender_server_prod"),
                        #     stage=rm_const.ReleaseStatus.stable
                        # ),
                        ri.YaDeployInfo(
                            services=deploy_releasable_items.DeployServiceWithResourcePatch(
                                service,
                                patch_configuration=[
                                    deploy_chz_details.recommender_deploy_service_static_layer_patch_stub(
                                        layer_id="recommender",
                                    )
                                ],
                            ),
                            stage=release_status
                        )
                        for service, release_status in deploy_chz_details.recommender_services_with_release_types()
                    ] + [
                        # crutch: releasing to SB so that last released resource ≈ deployed (relevant in shooting tasks)
                        ri.SandboxInfo(stage=rm_const.ReleaseStatus.stable)
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        deploy_system = rm_const.DeploySystem.ya_deploy

    class Notify(ci.ReferenceCIConfig.Notify):
        use_startrek = False  # можно стереть и добавить секцию Startrek, если нужны релизные тикеты

        class Telegram(ci.ReferenceCIConfig.Notify.Telegram):
            chats = []
            invite_link = 'https://t.me/+HhA557sq5uk0MzVi'

    class ChangelogCfg(ci.ReferenceCIConfig.ChangelogCfg):
        wiki_page = None
        dirs = [
            "dj/services/chz",
        ]
