# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core import responsibility
from sandbox.projects.release_machine.components.config_core.bases import ci
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.graph import base as graph_base
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.configs.chz import _common as chz_rm_common
from sandbox.projects.release_machine.components.configs.chz import deploy_chz_details
from sandbox.projects.release_machine.components.configs.chz import ci_consts as chz_ci_consts
from sandbox.projects.release_machine.components.configs.chz.deploy_to_deploy import releasable_items as deploy_releasable_items
from sandbox.projects.release_machine.components.configs.chz.deploy_to_deploy import basic_build_presets as local_basic_build_presets


shard_resource_in_spec = "shard"


class ChzRecommenderShardCfg(ci.ReferenceCIConfig):
    name = "chz_recommender_shard"
    responsible = responsibility.Responsible(
        abc=responsibility.Abc(
            service_name="chz",
            schedule_slug="base_duty",
        ),
        login="phil-grab",
    )

    class JG(local_basic_build_presets.JGDeployReleaseSupportedCfgMixin, basic_build_presets.SingleBuildYaMakeJGCfg):
        @jg_flow.register_flow()
        def release(self):
            dummy = dummy_cubes.Dummy(manual=False)
            return graph_base.Graph([dummy])

        @jg_flow.register_flow(
            title="PR test&release for chz shard",
            description="Testing (in sandbox) and releasing (from the same PR) chz recommender shard with data",
            triggers=[
                jg_flow.ActionTrigger(
                    on=jg_flow.ActionTriggerOn.PR,
                    into="trunk",
                    required=True,
                    filters=[{'feature-branches': '**/{}_**'.format(chz_ci_consts.AUTORELEASE_BRANCH_PREFIX)}],
                )
            ]
        )
        def chz_shard_update_testing(self):
            first_releasable_item = self.root_cfg.releases_cfg.releasable_items[0]

            target = first_releasable_item.build_data.target
            artifact = first_releasable_item.build_data.artifact
            resource_type = first_releasable_item.data.resource_type

            dummy = dummy_cubes.Dummy(manual=False)

            build = build_cubes.KosherYaMake(
                targets=[target],
                artifacts=[artifact],
                resource_types=[resource_type],
                needs=[dummy],
            )

            perf_test = chz_rm_common.make_chz_recommender_pair_perf_cube(
                test_stand_resources=chz_rm_common.make_build_cube_dep_for_resource(
                    build_cube=build,
                    spec_resource_name=shard_resource_in_spec
                )
            )

            notify_about_release_cube = chz_rm_common.make_chz_release_notify_cube(
                spec_resource_type=shard_resource_in_spec,
            )

            accept_release_cubes = chz_rm_common.make_accept_release_cubes(
                build_stage_cube=build,
                test_stage_cubes=[perf_test],
                release_stage_cube=notify_about_release_cube,
            )

            graph_steps = [
                dummy,
                build,
                perf_test,
                notify_about_release_cube,
            ] + list(accept_release_cubes)
            graph = graph_base.Graph(graph_steps)

            for cube in self._get_release_cubes(graph, build):
                cube.add_requirement(notify_about_release_cube)
                cube.manual = False
                graph.add(cube)

            return graph

    class CI(ci.ReferenceCIConfig.CI):
        a_yaml_dir = "dj/services/chz/data/shard"
        secret = "sec-01f1pse0y7chjt929599g72qk2"
        sb_owner_group = "CHZ"

        ya_make_abs_paths_glob = [
            "dj/services/chz/data/shard/*",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(ci.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="chz_recommender_shard",
                    data=ri.SandboxResourceData("CHZ_DJ_SHARD"),
                    build_data=ri.BuildData(
                        target="dj/services/chz/data/shard",
                    ),
                    deploy_infos=[
                        ri.YaDeployInfo(
                            services=deploy_releasable_items.DeployServiceWithResourcePatch(
                                service,
                                patch_configuration=[
                                    deploy_chz_details.recommender_deploy_service_static_resource_patch_stub(
                                        resource_name="shard.bin",
                                    )
                                ],
                            ),
                            stage=release_status
                        )
                        for service, release_status in deploy_chz_details.recommender_services_with_release_types()
                    ] + [
                        # crutch: releasing to SB so that last released resource ≈ deployed (relevant in shooting tasks)
                        ri.SandboxInfo(stage=rm_const.ReleaseStatus.stable)
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        deploy_system = rm_const.DeploySystem.ya_deploy
        main_release_flow_branch_auto_start = False

    class Notify(ci.ReferenceCIConfig.Notify):
        use_startrek = False  # можно стереть и добавить секцию Startrek, если нужны релизные тикеты

        class Telegram(ci.ReferenceCIConfig.Notify.Telegram):
            chats = []
            invite_link = 'https://t.me/+HhA557sq5uk0MzVi'
