from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base import SearchReleasesBuildTestCube
from sandbox.projects.release_machine.components.config_core.jg.cube.base import CubeInput


class ClickdaemonTestsBundle():
    @staticmethod
    def get_bundle(sanitizers, entry_cube):
        """
        Returns list of clickdaemon component tests

        :type sanitizers: List[str]
        :param sanitizers:
            List of sanitizers for BUILD_CLICKDAEMON tests

        :type entry_cube: Cube
        :param entry_cube:
            The name of the build stage entry cube for ya_make tests dependencies
        """

        return [
            SearchReleasesBuildTestCube(
                name="build_clickdaemon_test_{}".format(sanitizer) if sanitizer else "build_clickdaemon_test",
                task="projects/upper_search/clickdaemon/build_clickdaemon",
                input=CubeInput(
                    use_arcadia=True,
                    run_tests=True,
                    run_long_tests=True,
                    package_type="tarball",
                    packages="yweb/webdaemons/clickdaemon/deploy/package/package.json",
                    sanitize=sanitizer,
                ),
                needs=[entry_cube],
            ) for sanitizer in sanitizers
        ] + [
            SearchReleasesBuildTestCube(
                name="clickhandle_test",
                input=CubeInput(
                    test=True,
                    targets="yweb/weblibs/signurl/ut",
                ),
                needs=[entry_cube],
            )
        ]
