# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class CodesearchCfg(configs.ReferenceCIConfig):
    name = "codesearch"
    display_name = "Arcadia CodeSearch and Fast Code Search"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="arcadiacodesearch"),
        login="sskvor",
    )

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "devtools/codesearch"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-RELEASERS"

        ya_make_abs_paths_glob = [
            "devtools/codesearch/**",
        ]

    class JG(basic_build_presets.SingleBuildYaMakeTemplateJGCfg):
        build_task = "projects/codesearch/build_fast_codesearch"

        def _get_build_cube(self, graph):
            build = super(self.__class__, self)._get_build_cube(graph)
            build.input.update(thinlto=True)
            return build

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            deploy_infos = [ri.YaDeployInfo(ri.DeployService("codesearch"))]
            return [
                ri.ReleasableItem(
                    name="fcs-controller",
                    data=ri.SandboxResourceData("FAST_CODESEARCH_CONTROLLER", ttl=180),
                    deploy_infos=deploy_infos,
                ),
                ri.ReleasableItem(
                    name="fcs-indexer",
                    data=ri.SandboxResourceData("FAST_CODESEARCH_INDEXER", ttl=180),
                    deploy_infos=deploy_infos,
                ),
                ri.ReleasableItem(
                    name="fcs-searcher",
                    data=ri.SandboxResourceData("FAST_CODESEARCH_SEARCHER", ttl=180),
                    deploy_infos=deploy_infos,
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "mvel",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "mvel"
            queue = "CSREL"
            dev_queue = "CS"
            summary_template = u"Приемка Codesearch {}"
            add_commiters_as_followers = True
            use_task_author_as_assignee = False

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = None
        dirs = [
            "arcadia/devtools/codesearch",
        ]

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        start_version = 5  # moved to the CI since the 4th branch
