# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class CodesearchFastUiCfg(configs.ReferenceCIConfig):
    name = "codesearch_fast_ui"
    display_name = "Fast Codesearch UI"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="arcadiacodesearch"),
        login="mvel",
    )

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "devtools/codesearch/fast_ui"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-RELEASERS"

        ya_make_abs_paths_glob = [
            "devtools/codesearch/fast_ui/**",
        ]

    class JG(basic_build_presets.SingleBuildYaMakeJGCfg):
        pass

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            deploy_infos = [ri.YaDeployInfo(ri.DeployService("ui"))]
            return [
                ri.ReleasableItem(
                    name="codesearch_fast_ui",
                    build_data=ri.BuildData(
                        target="devtools/codesearch/fast_ui/codesearch_fast_ui",
                        artifact="devtools/codesearch/fast_ui/codesearch_fast_ui",
                    ),
                    data=ri.SandboxResourceData("FAST_CODESEARCH_UI", ttl=180),
                    deploy_infos=deploy_infos,
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "mvel",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "mvel"
            queue = "CSREL"
            dev_queue = "CS"
            summary_template = u"Приемка Fast Codesearch UI {}"
            add_commiters_as_followers = True
            use_task_author_as_assignee = False

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = None
        dirs = [
            "arcadia/devtools/codesearch/fast_ui",
        ]
