# coding: utf-8

import os

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core.jg import base as jg_base
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import release as release_cubes
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


BUILD_LAYER_TASKS_RESOURCES = {
    "BUILD_MULTIK_NGINX": "MULTIK_STAND_NGINX",
    "BUILD_MULTIK_SERVER_FRONTEND": "MULTIK_STAND_FRONTEND",
    "BUILD_MULTIK_WEB_SERVER": "MULTIK_STAND_SERVER",
    "BUILD_MULTIK_WORKER": "MULTIK_STAND_WORKER",
}
SANDBOX_TASKS_BINARY = {
    "MULTIK_BIG_INFUSE_BANNERS": "sandbox/projects/april/multik/tasks/MultikBigInfuse/bin",
    "MULTIK_IMPORT_BANNERS": "sandbox/projects/april/multik/tasks/MultikImportBanners/bin",
    "MULTIK_INFUSE": "sandbox/projects/april/multik/tasks/MultikInfuse/bin",
    "MULTIK_NIGHTLY_INDEX_MERGE": "sandbox/projects/april/multik/tasks/MultikNightlyIndexMerge",
    "MULTIK_RECATEGORIZE_KD_BANNERS": "april/multik/stand/recategorize_banners/sandbox_task",
}
KOSHER_YA_MAKE_TASKS = {
    "MULTIK_WEB_CLASSIFIER_SERVER": "april/multik/stand/classifier_server/bin/classifier_server",
}
SANDBOX_TASKS_BINARY_RESOURCE = "SANDBOX_TASKS_BINARY"
RELEASED_TYPES_MANUAL = {
    rm_const.ReleaseStatus.prestable: False,
    rm_const.ReleaseStatus.stable: True
}


def _get_release_rm_cubes(
    input_cube_key,
    component_name,
    release_entry,
    release_sb_resource,
    build_cube,
    deploy_system,
):
    releases_cubes = []
    for release_type, manual in RELEASED_TYPES_MANUAL.items():
        releases_cubes.append(release_cubes.ReleaseRmComponent2(
            name="release_{}_{}".format(input_cube_key, release_type),
            title="{} to {}".format(input_cube_key, release_type),
            manual=manual,
            where_to_release=release_type,
            component_name=component_name,
            needs=[release_entry],
            input=jg_cube.CubeInput(
                component_resources={input_cube_key: build_cube.output.resources[release_sb_resource].first().id},
                deploy_system=deploy_system.name,
            ),
        ))
    return releases_cubes


class ComdepMultikStandCfg(configs.ReferenceCIConfig):
    name = "comdep_multik_stand"
    display_name = "ComDep MultiK Stand"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="multik_stand"),
        login="robot-comdep-multik",
    )

    class JG(jg_base.BaseReleaseMachineJobGraph):
        @jg_flow.release_flow()
        def release(self):
            graph = super(ComdepMultikStandCfg.JG, self).release(self)
            main_entry = graph.get(dummy_cubes.RMMainGraphEntry.NAME)
            release_entry = dummy_cubes.ReleaseStageEntry()
            graph.add(release_entry)

            for task_name, release_sb_resource in BUILD_LAYER_TASKS_RESOURCES.items():
                task_name_lower = task_name.lower()
                build_cube = jg_cube.Cube(
                    name=task_name_lower,
                    needs=[main_entry],
                    task="projects/comdep_multik/{}".format(task_name_lower),
                )
                release_entry.add_requirement(build_cube)
                graph.add(build_cube)

                for release_cube in _get_release_rm_cubes(
                    input_cube_key=task_name_lower,
                    component_name=self.component_name,
                    release_entry=release_entry,
                    release_sb_resource=release_sb_resource,
                    build_cube=build_cube,
                    deploy_system=rm_const.DeploySystem.ya_deploy,

                ):
                    graph.add(release_cube)

            for sandbox_binary_task, target_path in SANDBOX_TASKS_BINARY.items():
                sandbox_binary_task_lower = sandbox_binary_task.lower()
                build_cube = build_cubes.DeployBinaryTask(
                    target=target_path,
                    target_task_type=sandbox_binary_task,
                    name=sandbox_binary_task_lower,
                    needs=[main_entry],
                )
                release_entry.add_requirement(build_cube)
                graph.add(build_cube)

                for release_cube in _get_release_rm_cubes(
                    input_cube_key=sandbox_binary_task_lower,
                    component_name=self.component_name,
                    release_entry=release_entry,
                    release_sb_resource=SANDBOX_TASKS_BINARY_RESOURCE,
                    build_cube=build_cube,
                    deploy_system=rm_const.DeploySystem.sandbox,
                ):
                    graph.add(release_cube)

            for ya_make_build_resource, target_path in KOSHER_YA_MAKE_TASKS.items():
                ya_make_build_resource_lower = ya_make_build_resource.lower()
                build_cube = build_cubes.KosherYaMake(
                    name=ya_make_build_resource_lower,
                    targets=os.path.dirname(target_path),
                    artifacts=target_path,
                    resource_types=ya_make_build_resource,
                    input=jg_cube.CubeInput(
                        result_single_file=True,
                        ya_yt_store=False,
                    ),
                    needs=[main_entry],
                )
                release_entry.add_requirement(build_cube)
                graph.add(build_cube)

                for release_cube in _get_release_rm_cubes(
                    input_cube_key=ya_make_build_resource_lower,
                    component_name=self.component_name,
                    release_entry=release_entry,
                    release_sb_resource=ya_make_build_resource,
                    build_cube=build_cube,
                    deploy_system=rm_const.DeploySystem.ya_deploy,
                ):
                    graph.add(release_cube)
            return graph

    class Releases(configs.ReferenceCIConfig.Releases):
        release_followers_permanent = ["robot-comdep-multik"]
        deploy_system = rm_const.DeploySystem.ya_deploy

        @property
        def releasable_items(self):
            result = []

            for task_name, release_sb_resource in BUILD_LAYER_TASKS_RESOURCES.items():
                task_name_lower = task_name.lower()
                result.append(ri.ReleasableItem(
                    name=task_name_lower,
                    data=ri.SandboxResourceData(release_sb_resource, ttl=30),
                    deploy_infos=[
                        ri.YaDeployInfo(ri.DeployService("{}_{}".format(task_name, release_type)), stage=release_type)
                        for release_type in RELEASED_TYPES_MANUAL
                    ],
                ))

            for sandbox_binary_task in SANDBOX_TASKS_BINARY:
                sandbox_binary_task_lower = sandbox_binary_task.lower()
                result.append(ri.ReleasableItem(
                    name=sandbox_binary_task_lower,
                    data=ri.SandboxResourceData(SANDBOX_TASKS_BINARY_RESOURCE, ttl=30),
                    deploy_infos=[
                        ri.YaDeployInfo(ri.DeployService("{}_{}".format(sandbox_binary_task_lower, release_type)), stage=release_type)
                        for release_type in RELEASED_TYPES_MANUAL
                    ],
                ))

            for ya_make_build_resource in KOSHER_YA_MAKE_TASKS:
                ya_make_build_resource_lower = ya_make_build_resource.lower()
                result.append(ri.ReleasableItem(
                    name=ya_make_build_resource_lower,
                    data=ri.SandboxResourceData(ya_make_build_resource, ttl=30),
                    deploy_infos=[
                        ri.YaDeployInfo(ri.DeployService("{}_{}".format(ya_make_build_resource_lower, release_type)), stage=release_type)
                        for release_type in RELEASED_TYPES_MANUAL
                    ],
                ))

            return result

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            queue = "CDMULTIKREL"
            assignee = "robot-comdep-multik"
            summary_template = u"ComDep Multik Stand releases ({})"
            workflow = {}
            add_commiters_as_followers = False
            followers = []

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        dirs = [
            "arcadia/april/multik",
            "arcadia/sandbox/projects/april/multik"
        ]
        wiki_page = "comdep-multik/releases/"

    class CI(configs.ReferenceCIConfig.CI):
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        a_yaml_dir = "sandbox/projects/release_machine/components/configs/comdep_multik"
        sb_owner_group = "COMDEP-MULTIK"
