# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri


RESOURCES = [
    "HORIZON_AGENT_CONFIG_COMMON",
    "APP_HOST_STABLE_BRANCH_COMMON",
]


class CommonGraphsCfg(configs.ReferenceBranchedConfig):
    name = "common_graphs"
    responsible = "ashishkin"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = "CMNT"
        each_rev_default = False

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):

            @property
            def _prerelease(self):
                """
                    Prerelease part of job graph for Testenv with arrows and dependencies
                    :return: list with jobs
                """
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementWiki(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrekWiki(
                        job_params={
                            "next_revision_custom_schedule": jg_utils.CustomSchedule(
                                last_run_finished=False,
                                seconds_from_last_run_commit=3600,
                                seconds_from_last_run_start_time=3600,
                                time_interval_list=[(12, 13), (17, 18)],
                                weekday_list=[0, 1, 2, 3, 4, 5],
                            )
                        }
                    ),
                ]

            _preset = jg_presets.SingleBuildPreset(
                build_task_name="BUILD_HORIZON_AGENT_CONFIG",
                build_ctx={
                    "vertical": "COMMON",
                },
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable),
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.testing),
                ],
            )

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=resource.lower(),
                    data=ri.SandboxResourceData(resource, ttl=90),
                    deploy_infos=[ri.single_nanny_service("production-app-host-vla-common-yp")],
                ) for resource in RESOURCES
            ]

        allow_robots_to_release_stable = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/common"
        tag_name = "apphost/conf/common"

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "dmitryno"
            queue = "SEAREL"
            summary_template = u"Приемка графов COMMON {}"
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7
            commit_importance_threshold = 5

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "apphost/graphs/common/"
        ya_make_targets = [
            "arcadia/apphost/conf/verticals/COMMON",
            "arcadia/apphost/conf/backends",
        ]
