# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri

from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class CoresCfg(configs.ReferenceCIConfig):
    name = "cores"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="cores"),
        login="mvel",
    )

    class JG(basic_build_presets.SingleBuildYaMakeTemplateJGCfg):
        build_task = "BUILD_CORES"

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "infra/cores"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-RELEASERS"

        ya_make_abs_paths_glob = [
            "infra/cores/**",
            "sandbox/sdk2/helpers/coredump_filter/**",
        ]

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="cores_binary",
                    data=ri.SandboxResourceData("CORES_BINARY", ttl=180),
                    deploy_infos=[
                        ri.single_nanny_service("cores"),
                        ri.single_nanny_service("cores", stage="testing"),
                    ],
                ),
            ]

        allow_old_releases = True

    class Notify(configs.ReferenceCIConfig.Notify):
        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = ["cores_dev"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "mvel"
            queue = "CORESREL"
            dev_queue = "CORES"
            summary_template = u"Приемка Cores {}"
            followers = [
                "mvel",
                "ilyaturuntaev",
            ]
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = None
        dirs = [
            "arcadia/infra/cores",
            "arcadia/sandbox/sdk2/helpers/coredump_filter",
        ]

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        start_version = 44  # flow renamed since 43
