# -*- coding: utf-8 -*-
import re

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.job_graph.presets import ci_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class CVUniversalPyDaemon(configs.ReferenceCIConfig):
    name = "cv_universal_py_daemon"
    description = u"CV universal daemon"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="cvsearch"),
        login="woxalex",
    )

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "cv/cbir_search/daemons/cv_universal_daemon"
        secret = "sec-01fcwxqbymhmj4dfzr0eptsp67"
        sb_owner_group = "CV-RELEASERS"
        grant_config_update_permissions_to_release_machine_robot = False

        class JobGraph(configs.ReferenceCIConfig.CI.JobGraph):
            _preset = ci_presets.SingleBuildCiPreset(
                build_task_name="KOSHER_YA_MAKE",
                build_ctx={
                    "build_type": "release",
                    "use_dev_version": False,
                    "targets": "cv/cbir_search/daemons/cv_universal_daemon/",
                    "arts": "cv/cbir_search/daemons/cv_universal_daemon/cv_universal_daemon",
                    "test": False,
                    "strip_binaries": True,
                    "result_single_file": True,
                    "result_rt": "CV_UNIVERSAL_PY_DAEMON_EXECUTABLE"
                },
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)
                ],
            )

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="universal_daemon",
                    data=ri.SandboxResourceData("CV_UNIVERSAL_PY_DAEMON_EXECUTABLE", ttl=40),
                    deploy_infos=[
                        ri.single_nanny_service("hamster-universal-daemon"),
                        ri.single_nanny_service("production-sas-universal-daemon"),
                        ri.single_nanny_service("production-man-universal-daemon"),
                        ri.single_nanny_service("production-vla-universal-daemon")
                    ],
                )
            ]
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceCIConfig.Notify):

        use_startrek = False

        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = ["cvduty"]

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = ""
        dirs = []
        markers = [
            (4, re.compile(r"(\[CV Daemon\])", flags=re.IGNORECASE)),
            (4, re.compile(r"(\[CV\])", flags=re.IGNORECASE)),
        ]

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        arc_branches_folder = "releases/cv_universal_py_daemon"
        arc_tag_folder = "tags/releases/cv_universal_py_daemon"
