# -*- coding: utf-8 -*-

from sandbox.projects.common.constants import constants as common_const
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri


class DialogovoCfg(configs.ReferenceBranchedConfig):
    name = "dialogovo"
    display_name = "Alisa PASkills Dialogovo"
    responsible = configs.Responsible(
        abc=configs.Abc(component_id=1886),
        login="kuptservol",
    )

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "PASKILLS"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildPackageBranched(
                        resource_names="DIALOGOVO_BINARY",
                        package_names="alice/paskills/dialogovo/pkg.json",
                        job_params={
                            "apiargs": {
                                'kill_timeout': 2700,
                            },
                        },
                        ctx={
                            'package_type': 'docker',
                            "build_type": "release",
                            'docker_push_image': True,
                            'docker_registry': 'registry.yandex.net',
                            'docker_image_repository': 'paskills',
                            'docker_user': 'robot-paskills-ci',
                            'docker_token_vault_name': 'robot-paskills-ci-docker-registry-token',
                            'docker_build_network': 'host',
                            'checkout': False,
                            'ya_yt_store': True,
                            'ignore_recurses': True,
                            common_const.BUILD_SYSTEM_KEY: common_const.SEMI_DISTBUILD_BUILD_SYSTEM
                        },
                        out={"DIALOGOVO_BINARY": 20},
                    )
                )

                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="ALICE_EVO_INTEGRATION_TESTS_WRAPPER",
                    job_params={
                        "job_name_parameter": "ALICE_EVO_INTEGRATION_TESTS_WRAPPER",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    ctx={
                        "test_filters": "external_skills flash_briefings recipes iot",
                        "megamind_url": "http://vins.hamster.alice.yandex.net/speechkit/app/pa/"
                                        "?srcrwr=Dialogovo:http://paskills-common-testing.alice.yandex.net/"
                                        "dialogovo-priemka/megamind/"
                                        "&srcrwr=ExternalSkillRecipes:http://paskills-common-testing.alice.yandex.net/"
                                        "dialogovo-priemka/megamind/recipes/"
                                        "&srcrwr=ExternalSkillFlashBriefing:paskills-common-testing.alice.yandex.net/"
                                        "dialogovo-priemka/flash_briefing/",
                        "launch_type": "dialogovo",
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerRelease(
                            job_name_parameter=rm_const.ReleaseStatus.testing
                        ),
                        jg_job_triggers.JobTriggerNewTag(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="tag_number",
                                    output_key="new_tag_number",
                                ),
                            )
                        ),
                        jg_arrows.ParamsData("branch_number", jg_utils.get_major_release_number),
                    )
                ))

                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="DIALOGOVO_BINARY",
                                            resource_name="DIALOGOVO_BINARY",
                                        )
                                    )
                                )
                            ),
                            job_params={
                                "observed_paths": [
                                    'alice/kronstadt',
                                    'alice/paskills/dialogovo'
                                ],
                            },
                        )
                    )
                    release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                        release_to=release_stage,
                    ))
                release_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranched(
                        job_arrows=(
                            jg_job_triggers.JobTriggerChangelogFinal(),
                            jg_job_triggers.JobTriggerNewTag(),
                        )
                    )
                )
                return release_part

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["dialogovo-releases"]

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """
            Startrek notifications

            https://wiki.yandex-team.ru/releasemachine/startrekoptions/
            """

            assignee = "osennikovak"
            queue = "ALICERELEASE"
            dev_queue = "PASKILLS"
            summary_template = u"Релиз Alisa PASkills Dialogovo {}"

            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                assignee,
                "kuptservol"
                "pazus",
                "svintenok"
            ]
            add_commiters_as_followers = True
            hide_commits_under_cut = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        use_arc = True
        arc_tag_folder = "tags/releases/alice/paskills"
        arc_branches_folder = "releases/alice/paskills"

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """
        Changelog configuration

        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """

        dirs = ["arcadia/alice/paskills/dialogovo"]
        wiki_page = ""

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="DIALOGOVO_BINARY",
                    data=ri.SandboxResourceData("DIALOGOVO_BINARY"),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            ri.DeployService("dialogovo_{}".format(loc)) for loc in rm_const.MAIN_LOCATIONS
                        ),
                        ri.NannyDeployInfo(
                            [ri.DeployService("dialogovo_testing"), ri.DeployService("dialogovo_priemka")],
                            stage=rm_const.ReleaseStatus.testing,
                        ),
                    ]
                )
            ]

        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 10 * 60  # 10 min
