# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


RESOURCES = [
    "HORIZON_AGENT_CONFIG_DISTRICT",
    "APP_HOST_STABLE_BRANCH_DISTRICT",
]


class DistrictGraphsCfg(configs.ReferenceBranchedConfig):
    name = "district_graphs"
    # TODO: Set Component responsible
    responsible = "yurikiselev"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "DISTRICT"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SingleBuildPreset(
                build_task_name="BUILD_HORIZON_AGENT_CONFIG",
                build_ctx={
                    "vertical": "DISTRICT",
                },
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=resource.lower(),
                    data=ri.SandboxResourceData(resource, ttl=90),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            services=[
                                ri.DeployService("answers_backend_production_{}_yp".format(i))
                                for i in rm_const.MAIN_LOCATIONS
                            ]
                        ),
                    ],
                ) for resource in RESOURCES
            ]
        release_followers_permanent = [
            # TODO: Set Release Request Followers
            "yurikiselev",
        ]
        allow_robots_to_release_stable = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/district"
        tag_name = "apphost/conf/district"

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            queue = "YALOCAL"
            summary_template = u"Приемка графов DISTRICT {}"
            # TODO: Set Ticket followers for all DISTRICT graphs releases
            followers = [
            ]
            assignee = "yurikiselev"
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7
            commit_importance_threshold = 5

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "district/apphost/changelog/"
        ya_make_targets = [
            "arcadia/web/app_host/conf/graph_generator/vertical/DISTRICT",
        ]
